<?php

    require ('dbconnection.php');
    
    require ('../database/digital.php');

    // Verifica se o método da solicitação é POST
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Verifica se o ID do botão foi enviado
        if (isset($_POST["buttonId"])) {
            $buttonId = $_POST["buttonId"];
            
            // Chame a função para registrar o clique do botão
            registerButtonClick($conn, $buttonId);
        } else {
            echo "ID do botão não especificado.";
        }
    } else {
        echo "Método de solicitação inválido.";
    }
    
    // Função para registrar o clique do botão no banco de dados
    function registerButtonClick($conn, $buttonId) {
        try {
            // Atualiza o contador de cliques para o botão correspondente
            $stmt = $conn->prepare("UPDATE buttons SET clicks = clicks + 1 WHERE id_button = ?");
            $stmt->bindParam(1, $buttonId, PDO::PARAM_INT);
            $stmt->execute();
            // Retorna um código de status 200 para indicar que o clique foi registrado com sucesso
            http_response_code(200);
        } catch (PDOException $e) {
            // Em caso de erro, retorna um código de status 500
            http_response_code(500);
            echo "Erro ao registrar o clique do botão: " . $e->getMessage();
        }
    }

?>