<?php

    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: index.php");
        exit;
    }

?>

<html>
    <head>
      <title>Portal - Guaçu Digital - Admin</title>
      
      
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
      
        <script type="text/javascript" language="javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    	<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    	<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
      
        <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/js/bootstrap.min.js"></script>
        <script src="https://cpwebassets.codepen.io/assets/common/stopExecutionOnTimeout-2c7831bb44f98c1391d6a4ffda0e1fd302503391ca806e7fcc7b9b87197aec26.js"></script>
      
      
        <style>
            body {
                margin:0;
                padding:0;
                background-color:#f1f1f1;
            }
            .box {
                width:1280px;
                padding:20px;
                background-color:#fff;
                border:1px solid #ccc;
                border-radius:5px;
                margin-top:25px;
            }
            .pixel {
                display: inline-block;
                background-color: #000;
                width: 50px;
                height: 50px;
            }
            .filterDetail {
                font-family: "Consolas", "Menlo", "Ubuntu Mono", monospace;
            }
            .iconpreview {
                max-width: 60px;
                max-height: 60px;
                filter: invert(100%) sepia(0%) saturate(7499%) hue-rotate(65deg) brightness(100%) contrast(104%);
                height: 100%;
            }
            .modal-dialog {
                max-width: 610px;
                margin: 0 auto;
                padding: 20px;
                background-color: #fff;
                border-radius: 10px;
                box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            }
            .modal-title {
                color: #333;
             }
            .modal-body {
                margin-bottom: 10px;
            }
            label {
                font-weight: bold;
            }
            .form-control {
                width: 100%;
                /*padding: 8px;*/
                border: 1px solid #ccc;
                border-radius: 4px;
                box-sizing: border-box;
                margin-bottom: 10px;
            }
            textarea {
                width: 100%;
                padding: 8px;
                border: 1px solid #ccc;
                border-radius: 4px;
                box-sizing: border-box;
            }
            select {
                width: 100%;
                padding: 8px;
                border: 1px solid #ccc;
                border-radius: 4px;
            }
            button {
                padding: 8px 15px;
                background-color: #19837f;
                color: #fff;
                border: none;
                border-radius: 4px;
                cursor: pointer;
            }
            button:hover {
                background-color: #156d6b;
            }
              
            .pickcolor{
            	align-items: center;
            	text-align: center;
            }
            .container {
                max-width: 1280px;
            }
        </style>
    </head>
    <body>
      <div class="container box">
       <h1 align="center"></h1>
       <br />
       <div class="table-responsive">
        <br />
        <div align="right">     
         <button type="button" id="add_button" data-toggle="modal" data-target="#buttonModal" class="btn btn-info btn-lg">Adicionar Botão</button>
        </div>
        <br /><br />
    
        <table id="button_data" class="table table-striped table-bordered" style="width:100%">
         <thead>
          <tr>
           <th>Icone</th>
           <th>Rotulo</th>
           <th>Tags</th>
           <th>Url</th>
           <th>Grupo</th>
           <th>Status</th>
           <th>Editar</th>
           <th>Remover</th>
          </tr>
         </thead>
        </table>
        
       </div>
      </div>
    </body>
</html>


<div id="buttonModal" class="modal fade">
	<div class="modal-dialog">
		<form method="post" id="button_form" enctype="multipart/form-data">
			<div class="modal-content">
				<div class="modal-header">					
					<h4 class="modal-title">Adicionar Botão</h4>
				</div>
				<div class="modal-body">
					<label>Rotulo do botão:</label>
					<input type="text" name="label" id="label" class="form-control">
					<br>

					<label>URL do Botão:</label>
					<input type="text" name="url" id="url" class="form-control">
						
					<br>
										
					<label>Tags:</label>
							
					<br>
							
					<textarea name="tags" id="tags" rows="5" cols="78">Exemplo(boleto,arrecadação...)</textarea>
							
					<br>
					<br>

					<label for="categoria">Grupo:</label>
							
					<br>
							
					<select name="categoria" id="categoria">

						<?php
                            // Replace 'your_database.db' with the path to your SQLite database file
                            $dbname = '../database/digital.db';
                            
                            try {
                                // Create a new SQLite PDO connection
                                $conn = new PDO("sqlite:$dbname");
                                $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                            
                                // Consulta para obter os grupos da tabela "grupo"
                                $sqlGrupos = "SELECT * FROM groups ORDER BY name ASC";
                                $resultGrupos = $conn->query($sqlGrupos);
                                
                            
                                // Laço para imprimir os grupos e as imagens relacionadas a eles
                                if (count($resultGrupos) > 0) {
                                    foreach ($resultGrupos as $rowGrupo) {
                                        echo '<option value="' . $rowGrupo["id_group"] . '" class="form-control">' . $rowGrupo["name"] . '</option>';
                                    }
                                } else {
                                    echo "Nenhum grupo encontrado na tabela.";
                                }
                            
                                // Close the database connection (optional, as PDO closes automatically when the script ends)
                                $conn = null;
                            } catch (PDOException $e) {
                                die("Connection failed: " . $e->getMessage());
                            }
                        ?>          
						
					</select>
					
					<br><br>
					
					<input type="radio" id="enable" name="is_active" value="1">
                    <label for="enable">habilitado</label>
              
                    <input type="radio" id="disable" name="is_active" value="0">
                    <label for="disable">desabilitado</label><br>

					
										
					<fieldset>
									
						<label>Escolher imagem</label>
						<input type="file" name="icon_image" id="icon_image" onchange="loadFile(event)">
						<span id="icon_uploaded_image"></span>
											
						<br> 
						<br>						
						
						<div class="row pickcolor">
						  <div class="col-sm">
							<label for="favcolor">Cor do fundo:</label>
							<input type="color" class="target" id="bgroundcolor" name="backgroundpcolor" value="#000">
						  </div>
						  <div class="col-sm">
							<label for="favcolor">Cor do Icone:</label>
							<input type="color" class="target" id="iconcolor" name="groupcolor" value="#ffffff">
						  </div>
						  <div class="col-sm">
							<button class="execute">Aplicar cor</button>
						  </div>
						</div>					
						
						<br> 
						<br>
										
					</fieldset>
									  
					<div id="iconbg" style="display: flex; justify-content: center; align-items: center; width: 100px; height: 100px; margin-top:5px; border-radius: 5px; background: #000; text-align: center; font-size: 30px; line-height: 55px; color: #ffffff;">
						<span style="width: 60px; height: 60px;">
							<img class="iconpreview" id="output">
						</span>  
					</div>					
				</div>
				<div class="modal-footer">
						<input type="hidden" name="id_button" id="id_button">
						<input type="hidden" name="operation" id="operation" value="Add">
						<input type="hidden" name="iconcolor" id="piccolor">
						<input type="hidden" name="bgcolor" id="bgcolor">
						<input type="submit" name="action" id="action" class="btn btn-success" value="Add">
						<button type="button" class="btn btn-danger" data-dismiss="modal">Fechar</button>
				</div>
			</div>
		</form>
	</div>
</div>

<script>
    $(document).ready(function(){
        var groupColors = {};

        function loadGroupColors() {
            $.ajax({
                url: "loadGroupColors.php",
                method: "POST",
                success: function(data) {
                    groupColors = JSON.parse(data);
                }
            });
        }

        loadGroupColors();

        $('#categoria').change(function() {
            var selectedGroupId = $(this).val();
            if (selectedGroupId in groupColors) {
                var selectedGroupColor = groupColors[selectedGroupId];
                $('#bgroundcolor').val(selectedGroupColor);
                $('#iconbg').css('background-color', selectedGroupColor);
            }
        });
    });    
</script>        

<!-- Image upload preview -->
<script>
  var loadFile = function(event) {
    var output = document.getElementById('output');
    output.src = URL.createObjectURL(event.target.files[0]);
    output.onload = function() {
      URL.revokeObjectURL(output.src) // free memory
    }
  };
</script>

<script id="rendered-js" >
'use strict';

class Color {
  constructor(r, g, b) {
    this.set(r, g, b);
  }

  toString() {
    return `rgb(${Math.round(this.r)}, ${Math.round(this.g)}, ${Math.round(this.b)})`;
  }

  set(r, g, b) {
    this.r = this.clamp(r);
    this.g = this.clamp(g);
    this.b = this.clamp(b);
  }

  hueRotate(angle = 0) {
    angle = angle / 180 * Math.PI;
    const sin = Math.sin(angle);
    const cos = Math.cos(angle);

    this.multiply([
    0.213 + cos * 0.787 - sin * 0.213,
    0.715 - cos * 0.715 - sin * 0.715,
    0.072 - cos * 0.072 + sin * 0.928,
    0.213 - cos * 0.213 + sin * 0.143,
    0.715 + cos * 0.285 + sin * 0.140,
    0.072 - cos * 0.072 - sin * 0.283,
    0.213 - cos * 0.213 - sin * 0.787,
    0.715 - cos * 0.715 + sin * 0.715,
    0.072 + cos * 0.928 + sin * 0.072]);

  }

  grayscale(value = 1) {
    this.multiply([
    0.2126 + 0.7874 * (1 - value),
    0.7152 - 0.7152 * (1 - value),
    0.0722 - 0.0722 * (1 - value),
    0.2126 - 0.2126 * (1 - value),
    0.7152 + 0.2848 * (1 - value),
    0.0722 - 0.0722 * (1 - value),
    0.2126 - 0.2126 * (1 - value),
    0.7152 - 0.7152 * (1 - value),
    0.0722 + 0.9278 * (1 - value)]);

  }

  sepia(value = 1) {
    this.multiply([
    0.393 + 0.607 * (1 - value),
    0.769 - 0.769 * (1 - value),
    0.189 - 0.189 * (1 - value),
    0.349 - 0.349 * (1 - value),
    0.686 + 0.314 * (1 - value),
    0.168 - 0.168 * (1 - value),
    0.272 - 0.272 * (1 - value),
    0.534 - 0.534 * (1 - value),
    0.131 + 0.869 * (1 - value)]);

  }

  saturate(value = 1) {
    this.multiply([
    0.213 + 0.787 * value,
    0.715 - 0.715 * value,
    0.072 - 0.072 * value,
    0.213 - 0.213 * value,
    0.715 + 0.285 * value,
    0.072 - 0.072 * value,
    0.213 - 0.213 * value,
    0.715 - 0.715 * value,
    0.072 + 0.928 * value]);

  }

  multiply(matrix) {
    const newR = this.clamp(this.r * matrix[0] + this.g * matrix[1] + this.b * matrix[2]);
    const newG = this.clamp(this.r * matrix[3] + this.g * matrix[4] + this.b * matrix[5]);
    const newB = this.clamp(this.r * matrix[6] + this.g * matrix[7] + this.b * matrix[8]);
    this.r = newR;
    this.g = newG;
    this.b = newB;
  }

  brightness(value = 1) {
    this.linear(value);
  }
  contrast(value = 1) {
    this.linear(value, -(0.5 * value) + 0.5);
  }

  linear(slope = 1, intercept = 0) {
    this.r = this.clamp(this.r * slope + intercept * 255);
    this.g = this.clamp(this.g * slope + intercept * 255);
    this.b = this.clamp(this.b * slope + intercept * 255);
  }

  invert(value = 1) {
    this.r = this.clamp((value + this.r / 255 * (1 - 2 * value)) * 255);
    this.g = this.clamp((value + this.g / 255 * (1 - 2 * value)) * 255);
    this.b = this.clamp((value + this.b / 255 * (1 - 2 * value)) * 255);
  }

  hsl() {
    // Code taken from https://stackoverflow.com/a/9493060/2688027, licensed under CC BY-SA.
    const r = this.r / 255;
    const g = this.g / 255;
    const b = this.b / 255;
    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);
    let h,s,l = (max + min) / 2;

    if (max === min) {
      h = s = 0;
    } else {
      const d = max - min;
      s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
      switch (max) {
        case r:
          h = (g - b) / d + (g < b ? 6 : 0);
          break;

        case g:
          h = (b - r) / d + 2;
          break;

        case b:
          h = (r - g) / d + 4;
          break;}

      h /= 6;
    }

    return {
      h: h * 100,
      s: s * 100,
      l: l * 100 };

  }

  clamp(value) {
    if (value > 255) {
      value = 255;
    } else if (value < 0) {
      value = 0;
    }
    return value;
  }}


class Solver {
  constructor(target, baseColor) {
    this.target = target;
    this.targetHSL = target.hsl();
    this.reusedColor = new Color(0, 0, 0);
  }

  solve() {
    const result = this.solveNarrow(this.solveWide());
    return {
      values: result.values,
      loss: result.loss,
      filter: this.css(result.values) };

  }

  solveWide() {
    const A = 5;
    const c = 15;
    const a = [60, 180, 18000, 600, 1.2, 1.2];

    let best = { loss: Infinity };
    for (let i = 0; best.loss > 25 && i < 3; i++) {if (window.CP.shouldStopExecution(0)) break;
      const initial = [50, 20, 3750, 50, 100, 100];
      const result = this.spsa(A, a, c, initial, 1000);
      if (result.loss < best.loss) {
        best = result;
      }
    }window.CP.exitedLoop(0);
    return best;
  }

  solveNarrow(wide) {
    const A = wide.loss;
    const c = 2;
    const A1 = A + 1;
    const a = [0.25 * A1, 0.25 * A1, A1, 0.25 * A1, 0.2 * A1, 0.2 * A1];
    return this.spsa(A, a, c, wide.values, 500);
  }

  spsa(A, a, c, values, iters) {
    const alpha = 1;
    const gamma = 0.16666666666666666;

    let best = null;
    let bestLoss = Infinity;
    const deltas = new Array(6);
    const highArgs = new Array(6);
    const lowArgs = new Array(6);

    for (let k = 0; k < iters; k++) {if (window.CP.shouldStopExecution(1)) break;
      const ck = c / Math.pow(k + 1, gamma);
      for (let i = 0; i < 6; i++) {if (window.CP.shouldStopExecution(2)) break;
        deltas[i] = Math.random() > 0.5 ? 1 : -1;
        highArgs[i] = values[i] + ck * deltas[i];
        lowArgs[i] = values[i] - ck * deltas[i];
      }window.CP.exitedLoop(2);

      const lossDiff = this.loss(highArgs) - this.loss(lowArgs);
      for (let i = 0; i < 6; i++) {if (window.CP.shouldStopExecution(3)) break;
        const g = lossDiff / (2 * ck) * deltas[i];
        const ak = a[i] / Math.pow(A + k + 1, alpha);
        values[i] = fix(values[i] - ak * g, i);
      }window.CP.exitedLoop(3);

      const loss = this.loss(values);
      if (loss < bestLoss) {
        best = values.slice(0);
        bestLoss = loss;
      }
    }window.CP.exitedLoop(1);
    return { values: best, loss: bestLoss };

    function fix(value, idx) {
      let max = 100;
      if (idx === 2 /* saturate */) {
          max = 7500;
        } else if (idx === 4 /* brightness */ || idx === 5 /* contrast */) {
          max = 200;
        }

      if (idx === 3 /* hue-rotate */) {
          if (value > max) {
            value %= max;
          } else if (value < 0) {
            value = max + value % max;
          }
        } else if (value < 0) {
        value = 0;
      } else if (value > max) {
        value = max;
      }
      return value;
    }
  }

  loss(filters) {
    // Argument is array of percentages.
    const color = this.reusedColor;
    color.set(0, 0, 0);

    color.invert(filters[0] / 100);
    color.sepia(filters[1] / 100);
    color.saturate(filters[2] / 100);
    color.hueRotate(filters[3] * 3.6);
    color.brightness(filters[4] / 100);
    color.contrast(filters[5] / 100);

    const colorHSL = color.hsl();
    return (
      Math.abs(color.r - this.target.r) +
      Math.abs(color.g - this.target.g) +
      Math.abs(color.b - this.target.b) +
      Math.abs(colorHSL.h - this.targetHSL.h) +
      Math.abs(colorHSL.s - this.targetHSL.s) +
      Math.abs(colorHSL.l - this.targetHSL.l));

  }

  css(filters) {
    function fmt(idx, multiplier = 1) {
      return Math.round(filters[idx] * multiplier);
    }
    return `filter: invert(${fmt(0)}%) sepia(${fmt(1)}%) saturate(${fmt(2)}%) hue-rotate(${fmt(3, 3.6)}deg) brightness(${fmt(4)}%) contrast(${fmt(5)}%);`;
  }}


function hexToRgb(hex) {
  // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
  const shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
  hex = hex.replace(shorthandRegex, (m, r, g, b) => {
    return r + r + g + g + b + b;
  });

  const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  return result ?
  [
  parseInt(result[1], 16),
  parseInt(result[2], 16),
  parseInt(result[3], 16)] :

  null;
}

$(document).ready(() => {
  $('button.execute').click((event) => { 
    event.preventDefault()
    const rgb = hexToRgb($('input#iconcolor').val());
    const bg = $('input#bgroundcolor').val()
    if (rgb.length !== 3) {
      alert('Invalid format!');
      return;
    }

    const color = new Color(rgb[0], rgb[1], rgb[2]);
    const solver = new Solver(color);
    const result = solver.solve();

    let lossMsg;
    if (result.loss < 1) {
      lossMsg = 'This is a perfect result.';
    } else if (result.loss < 5) {
      lossMsg = 'The is close enough.';
    } else if (result.loss < 15) {
      lossMsg = 'The color is somewhat off. Consider running it again.';
    } else {
      lossMsg = 'The color is extremely off. Run it again!';
    }

    $('.realPixel').css('background-color', color.toString());
    $('#iconbg').css('background-color', bg.toString());
    $('.iconpreview').attr('style', result.filter);
    $('.filterPixel').attr('style', result.filter);
    $('.filterDetail').text(result.filter);
    $('.lossDetail').html(`Loss: ${result.loss.toFixed(1)}. <b>${lossMsg}</b>`);
    $('#bgcolor').val(bg.toString());
    $('#piccolor').val(result.filter.toString());
  });
});
//# sourceURL=pen.js
</script>


<script type="text/javascript" language="javascript" >
$(document).ready(function(){

 $('#add_button').click(function(){
  $('#button_form')[0].reset();
  $('.modal-title').text("Adicionar Botão");
  $('#action').val("Add");
  $('#operation').val("Add");
  $('#icon_uploaded_image').html('');
 }); 

 $(document).on('submit', '#button_form', function(event){
  event.preventDefault();
  var label = $('#label').val();
  var url = $('#url').val();
  var categoria = $('#categoria').val();
  
   
  
  var extension = $('#icon_image').val().split('.').pop().toLowerCase();
  if(extension != '')
  {
   if(jQuery.inArray(extension, ['gif','png','jpg','jpeg','svg']) == -1)
   {
    alert("Invalid Image File");
    $('#icon_image').val('');
    return false;
   }
  } 
  if(label != '' && url != '' && categoria != '')
  {

   $.ajax({
    url:"buttonInsert.php",
    method:'POST',
    data:new FormData(this),
    contentType:false,
    processData:false,
    success:function(data)
    {
     alert(data);
     $('#button_form')[0].reset();
     $('#buttonModal').modal('hide');
     dataTable.ajax.reload();
    }
   });
  }
  else
  {
   alert("Both Fields are Required");
  }
 });

 var dataTable = $('#button_data').DataTable({
  "processing":true,
  "serverSide":true,
  "order":[],
  "ajax":{
   url:"buttonFetch.php",
   type:"POST"
  },
  "columnDefs":[
   {
    "targets":[0, 6, 7],
    "orderable":false,
   },
  ],
  "columns": [ // Adicione a definição da nova coluna aqui
    null, // Grupo
    null, // Cor
    {
      render: function (data, type, row) {
        return (row[5] == 'Ativo') ? 'Ativo' : 'Inativo'; // 2 é o índice da coluna "is_active"
      }
    },
    null, // Editar
    null // Remover
  ]
 });

 
 $(document).on('click', '.update', function(){
     
  var id_button = $(this).attr("id_button");
  $.ajax({
   url:"buttonFetch_single.php",
   method:"POST",
   data:{id_button:id_button},
   dataType:"json",
   success:function(data)
   {
    $('#buttonModal').modal('show');
    $('.modal-title').text("Editar Botão");
    
    $('#icon_uploaded_image').html(data.icon);
    $('#label').val(data.label);
    $('#tags').val(data.tags);
    $('#url').val(data.url);
    $('#categoria').val(data.id_group);
    $('#bgroundcolor').val(data.bgcolor.toString());
    $('#id_button').val(id_button);
    
    $('#iconbg').css('background-color', data.bgcolor.toString());
    $('.iconpreview').attr('style', (data.iconcolor.toString()));
    
    // Check the radio button based on the value of is_active
    if (data.is_active == 1) {
        $('#enable').prop('checked', true);
    } else {
        $('#disable').prop('checked', true);
    }
    
    $('#bgcolor').val(data.bgcolor.toString());
    $('#piccolor').val(data.iconcolor.toString());
    
    
    $('#action').val("Edit");
    $('#operation').val("Edit");
    
    $('#output').attr('src', $('#icon').attr('src'));
    
   }
  })
 });
 
 $(document).on('click', '.delete', function(){
  var id_button = $(this).attr("id_button");
  if(confirm("Are you sure you want to delete this?"))
  {
   $.ajax({
    url:"buttonDelete.php",
    method:"POST",
    data:{id_button:id_button},
    success:function(data)
    {
     alert(data);
     dataTable.ajax.reload();
    },
    error: function (data) {
        alert(JSON.stringify(data));
    }
   });
  }
  else
  {
   return false; 
  }
 });
 
 
});
</script>