<?php
// Conexão com o banco de dados
$dbname = '../database/digital.db';

try {
    // Criar uma nova conexão PDO SQLite
    $conn = new PDO("sqlite:$dbname");
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Consulta para obter os grupos e suas cores da tabela "grupo"
    $sql = "SELECT id_group, color FROM groups";
    $stmt = $conn->prepare($sql);
    $stmt->execute();

    // Array para armazenar as cores dos grupos
    $groupColors = [];

    // Loop através dos resultados da consulta
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $groupColors[$row['id_group']] = $row['color'];
    }

    // Fechar a conexão com o banco de dados
    $conn = null;

    // Retornar as cores dos grupos como JSON
    echo json_encode($groupColors);
} catch (PDOException $e) {
    // Em caso de erro na conexão
    echo "Erro: " . $e->getMessage();
}
?>