<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="css/flexy.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link href="http://fonts.googleapis.com/css?family=Roboto" rel="stylesheet" type="text/css">
    <link rel="icon" type="image/x-icon" href="/images/guacudigital.jpg">
    
    <title>Guaçu digital</title> 
    
    <meta name="description" content="Acesso rápido e prático aos serviços da Prefeitura de Mogi Guaçu">
    
    
</head>

<body>
    <div class="main">
        <div class="dp100" style="margin:0;padding:0;">
            <h6>
                <img src="images/guacudigital.png" alt="Guaçu Digital">
            </h6>
            <span class="client-subtitle">
                Acesso rápido e prático aos serviços da Prefeitura de Mogi Guaçu
            </span>
			</br>            
			<div class="form-group  btn2">
				<button class="btn">
				<i class="fa fa-search"></i>
				</button>
				<input type="text" id="searchInput" class="input" placeholder="Pesquisar">
			</div>
        </div>

        <?php
            // Replace 'your_database.db' with the path to your SQLite database file
            $dbname = 'database/digital.db';
            
            try {
                // Create a new SQLite PDO connection
                $conn = new PDO("sqlite:$dbname");
                $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
                // Define the charset to UTF-8 (Not applicable for SQLite, but included for consistency)
                $conn->exec("PRAGMA encoding = 'UTF-8';");
            
                // Consulta para obter os grupos da tabela "grupo"
                $sqlGrupos = "SELECT * FROM groups ORDER BY name ASC";
                $resultGrupos = $conn->query($sqlGrupos);
            
                // Consulta para obter as imagens da tabela "botoes" com base no id_grupo
                $sqlBotoes = "SELECT * FROM buttons WHERE id_group = :id_group";
                $stmtBotoes = $conn->prepare($sqlBotoes);
            
                // Sample usage: Fetch buttons for group with id_group = 1
                $id_group = 1;
                $stmtBotoes->execute(array(':id_group' => $id_group));
                $buttonsForGroup = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
            
                // Sample usage: Fetch buttons for group with id_group = 2
                $id_group = 2;
                $stmtBotoes->execute(array(':id_group' => $id_group));
                $buttonsForGroup2 = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
				
				// Fetch the data from PDOStatement objects into arrays
				$resultGruposArray = $resultGrupos->fetchAll(PDO::FETCH_ASSOC);
            
                // Laço para imprimir os grupos e as imagens relacionadas a eles
                if (count($resultGruposArray) > 0) {
					foreach ($resultGruposArray as $rowGrupo) {
                        echo '<div class="group-container dp100" style="background: linear-gradient(45deg, transparent 0%, ' . $rowGrupo["color"] . ' 0%, ' . $rowGrupo["color"] . ' 80%, transparent 0);">';
                        echo $rowGrupo["name"]; // Assumindo que o nome do grupo esteja na coluna "name"
                        echo '</div>';
                        echo '<hr class="hr" style="border: 3px solid ' . $rowGrupo["color"] . '; width:100%; margin:0; margin-bottom:5px;">';
            
                        echo '<div class="flex-container">';
            
                        $stmtBotoes->execute(array(':id_group' => $rowGrupo["id_group"]));
						$resultBotoesArray = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
            
                        // Imprime as imagens relacionadas ao grupo
                        foreach ($resultBotoesArray as $rowBotao) {
                            echo '<figure class="figure-container">';
                            echo '<a href="' . $rowBotao["url"] . '" target="_blank">';
                            echo '<div style="display: flex; justify-content: center; align-items: center; width: 106px; height: 106px; margin:5px; border-radius: 5px; background: ' . $rowBotao["bgcolor"] . '; text-align: center; font-size: 30px; line-height: 55px; color: #1e1e1e; box-shadow: 1px 1px 3px rgba(0, 0, 0, 0.5);">';
                        
                            $backgroundStyle = 'width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url(images/uploads/' . $rowBotao["icon"] . ');';
                        
                            if (pathinfo($rowBotao["icon"], PATHINFO_EXTENSION) === 'svg') {
                                $backgroundStyle .= $rowBotao["iconcolor"];
                            } else {
                                $backgroundStyle .= 'width: 95%; height: 95%;';
                            }
                        
                            echo '<span style="' . $backgroundStyle . '"></span>';
                            echo '</div>';
                            echo '<figcaption>' . $rowBotao["label"] . '</figcaption>';
                            echo '<figcaption hidden>' . $rowBotao["tags"] . '</figcaption>';
                            echo '</a>';
                            echo '</figure>';
                        }

            
                        echo '</div>';
                    }
                } else {
                    echo "Nenhum grupo encontrado na tabela.";
                }
            
                // Close the database connection (optional, as PDO closes automatically when the script ends)
                $conn = null;
            } catch (PDOException $e) {
                die("Connection failed: " . $e->getMessage());
            }
            ?>

    </div>
	<footer>
			<div class="card-footer">
				<p class="count"><span>PMMG/STI/DT 2023</span></p>
        	</div>  
    	</footer>

        <script>
        document.addEventListener("DOMContentLoaded", function() {
            const searchInput = document.getElementById("searchInput");
            const figureElements = document.querySelectorAll(".figure-container");
            const groupContainers = document.querySelectorAll(".group-container");
            const hrElements = document.querySelectorAll(".hr");

            function filterFigures() {
                const searchTerm = searchInput.value.trim().toLowerCase();
                figureElements.forEach(function(figure) {
                    const label = figure.querySelector("figcaption").textContent.toLowerCase();
                    const hiddenLabel = figure.querySelector("figcaption[hidden]").textContent.toLowerCase();

                    if (label.includes(searchTerm) || hiddenLabel.includes(searchTerm) || searchTerm === "") {
                        figure.style.display = "block";
                    } else {
                        figure.style.display = "none";
                    }
                });

                if (searchTerm === "") {
                    groupContainers.forEach(function(group) {
                        group.style.display = 'block';
                    });
                    hrElements.forEach(function(hr) {
                        hr.style.display = 'block';
                    });
                } else {
                    groupContainers.forEach(function(group) {
                        group.style.display = 'none';
                    });
                    hrElements.forEach(function(hr) {
                        hr.style.display = 'none';
                    });
                }
            }

            searchInput.addEventListener("input", filterFigures);
        });
    </script>

</body>

</html>