<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <link rel="icon" type="image/x-icon" href="/images/guacudigital.jpg">
    
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet" type="text/css">
    
    <link href="https://fonts.googleapis.com/css2?family=Lato&display=swap" rel="stylesheet">
	<link href="https://use.fontawesome.com/releases/v5.6.1/css/all.css" rel="stylesheet">
	
	<link rel="stylesheet" href="css/digital.css">
    
    <title>Guaçu digital</title> 
    
    <meta name="description" content="Acesso rápido e prático aos serviços da Prefeitura de Mogi Guaçu">
    
    
</head>

<body>
    <div id="background-image"></div>
    
    <div class="frame">

        <div class="main">
            <div class="dp100" style="margin:0;padding:0;">
                <h6>
                    <img src="images/guacudigital.png" alt="Guaçu Digital">
    			  </p>
    			  <span class="client-subtitle"> Acesso rápido e prático aos serviços da Prefeitura de Mogi Guaçu </span>
                </h6>
                        
    			<div class="form-group  btn2">
    				<button class="btn">
    				<i class="fa fa-search"></i>
    				</button>
    				<input type="text" id="searchInput" class="input" placeholder="Pesquisar">
    			</div>
            </div>
            
            <div id="grupo" class="grupo dp100"></div>
    
            <?php
            
                $dbname = 'database/digital.db';
                
                try {
                    // Crie uma nova conexão SQLite PDO
                    $conn = new PDO("sqlite:$dbname");
                    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                
                    // Defina o charset como UTF-8 (não aplicável para SQLite, mas incluído para consistência)
                    $conn->exec("PRAGMA encoding = 'UTF-8';");
                
                    // Consulta para obter os grupos da tabela "grupo"
                    $sqlGrupos = "SELECT * FROM groups WHERE is_active = 1 ORDER BY (name = 'Zeladoria') DESC, name ASC";
                    $resultGrupos = $conn->query($sqlGrupos);
                
                    // Consulta para obter as imagens da tabela "botoes" com base no id_grupo
                    $sqlBotoes = "SELECT * FROM buttons WHERE id_group = :id_group AND is_active = 1";
                    $stmtBotoes = $conn->prepare($sqlBotoes);
                
                    // Exemplo de uso: botões de busca para grupo com id_group = 1
                    $id_group = 1;
                    $stmtBotoes->execute(array(':id_group' => $id_group));
                    $buttonsForGroup = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
                
                    // Exemplo de uso: botões de busca para grupo com id_group = 2
                    $id_group = 2;
                    $stmtBotoes->execute(array(':id_group' => $id_group));
                    $buttonsForGroup2 = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
    				
    				// Busque os dados dos objetos PDOStatement em arrays
    				$resultGruposArray = $resultGrupos->fetchAll(PDO::FETCH_ASSOC);
    				
    				$gradientClasses = [];
                
                    // Laço para imprimir os grupos e os botões relacinados a eles
                    if (count($resultGruposArray) > 0) {
                        foreach ($resultGruposArray as $rowGrupo) {
                            $gradientClasses[] = 'gradient-' . $rowGrupo["id_group"];
                    
                            echo '<style>';
                            echo '.' . 'gradient-' . $rowGrupo["id_group"] . ':before { background: linear-gradient(to right, white, ' . $rowGrupo["color"] . '); }';
                            echo '.' . 'gradient-' . $rowGrupo["id_group"] . ':after { background: linear-gradient(to left, white, ' . $rowGrupo["color"] . '); }';
                            echo '</style>';
                    
                            echo '<div class="group-container dp100 divider gradient gradient-' . $rowGrupo["id_group"] . '" style="background-color: ' . $rowGrupo["color"] . ' ;">';
                            echo $rowGrupo["name"]; // Assumindo que o nome do grupo esteja na coluna "name"
                            echo '</div>';
                    
                            echo '<div class="grupo dp100">';
                            echo '<div class="flex-container">';
                    
                            $stmtBotoes->execute(array(':id_group' => $rowGrupo["id_group"]));
                            $resultBotoesArray = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
                    
                            $botaoRelacionado = false; // Variável de controle para verificar se há botões relacionados
                    
                            foreach ($resultBotoesArray as $rowBotao) {
                                $botaoRelacionado = true; // Há pelo menos um botão relacionado
                                echo '<figure class="figure-container">';
                                echo '<a href="' . $rowBotao["url"] . '" target="_blank" onclick="handleClick(' . $rowBotao["id_button"] . ')">'; // Add onclick event to handle button click
                                echo '<div class="buttons" style="background: ' . $rowBotao["bgcolor"] . ';">';
                                $backgroundStyle = 'width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url(images/uploads/' . $rowBotao["icon"] . ');';
                                if (pathinfo($rowBotao["icon"], PATHINFO_EXTENSION) === 'svg') {
                                    $backgroundStyle .= $rowBotao["iconcolor"];
                                } else {
                                    $backgroundStyle .= 'width: 95%; height: 95%;';
                                }
                                echo '<span style="' . $backgroundStyle . '"></span>';
                                echo '</div>';
                                echo '<figcaption>' . $rowBotao["label"] . '</figcaption>';
                                echo '<figcaption hidden>' . $rowBotao["tags"] . '</figcaption>';
                                echo '</a>';
                                echo '</figure>';
                            }
                    
                            if (!$botaoRelacionado) {
                                // Se não houver botões relacionados, oculta a div do grupo
                                echo '<style>';
                                echo '.gradient-' . $rowGrupo["id_group"] . ' { display: none; }';
                                echo '</style>';
                            }
                    
                            echo '</div>';
                            echo '</div>';
                        }
                    } else {
                        echo "Nenhum grupo encontrado na tabela.";
                    }

                
                    // Feche a conexão com o banco de dados (opcional, pois o PDO fecha automaticamente quando o script termina)
                    $conn = null;
                } catch (PDOException $e) {
                    die("Connection failed: " . $e->getMessage());
                }
                ?>
        
          

        </div>
        <footer>
		    <div class="card-footer">
				<p class="count"><span>PMMG/STI/DT 2023</span></p>
        	</div>  
    	</footer>  

	</div> 
	
	<input type="checkbox" id="check">
    <label for="check">
      <i class="fas fa-bars" id="btn"></i>
      <i class="fas fa-times" id="cancel"></i>
    </label>
    <div class="sidebar">
      <header>Menu</header>
      <a href="/zeladoria/solicitacao.php" class="active">
        <i class="fas fa-search"></i>
        <span>Consultar solicitações</span>
      </a>
    </div>
    
    <script>
        function handleClick(buttonId) {
            // Enviar o ID do botão clicado para o servidor
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    // O código aqui será executado quando a requisição AJAX for concluída com sucesso
                    console.log("Clique registrado com sucesso.");
                }
            };
            xhttp.open("GET", "registrar_clique.php?buttonId=" + buttonId, true);
            xhttp.send();
        }
    </script>
        
    <script>
        document.addEventListener("DOMContentLoaded", function () {
          const searchInput = document.getElementById("searchInput");
          const figureElements = document.querySelectorAll(".figure-container");
          const grupoContainer = document.getElementById("grupo");
    
          function filterFigures() {
            const searchTerm = searchInput.value.trim().toLowerCase();
            grupoContainer.innerHTML = ''; // Limpa o conteúdo do grupoContainer
    
            if (searchTerm === "") {
              return; // Se a pesquisa está vazia, não precisa continuar
            }
    
            const flexContainer = document.createElement('div'); // Criando a div que irá conter as flex-containers
            flexContainer.classList.add('flex-container');
    
            figureElements.forEach(function (figure) {
              const label = figure.querySelector("figcaption").textContent.toLowerCase();
              const hiddenLabel = figure.querySelector("figcaption[hidden]").textContent.toLowerCase();
              if (label.includes(searchTerm) || hiddenLabel.includes(searchTerm)) {
                const clonedFigure = figure.cloneNode(true);
                clonedFigure.style.display = "block";
                flexContainer.appendChild(clonedFigure); // Adiciona a figure clonada à div flex-container
              }
            });
    
            grupoContainer.appendChild(flexContainer); // Adiciona a div flex-container ao grupoContainer
          }
    
          searchInput.addEventListener("input", filterFigures);
    
          // Limpa a div grupoContainer quando o campo de pesquisa é limpo
          searchInput.addEventListener("change", function () {
            if (searchInput.value === "") {
              grupoContainer.innerHTML = '';
            }
          });
        });
    </script>

</body>

</html>