<?php
// Função para escurecer uma cor em hexadecimal
function darkenColor($hex, $percent) {
    // Remover "#" se estiver presente
    $hex = str_replace("#", "", $hex);

    // Converter para RGB
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));

    // Escurecer a cor
    $r = round($r * (1 - $percent));
    $g = round($g * (1 - $percent));
    $b = round($b * (1 - $percent));

    // Garantir que os valores estejam dentro do intervalo [0, 255]
    $r = ($r < 0 || is_nan($r)) ? 0 : (($r > 255) ? 255 : $r);
    $g = ($g < 0 || is_nan($g)) ? 0 : (($g > 255) ? 255 : $g);
    $b = ($b < 0 || is_nan($b)) ? 0 : (($b > 255) ? 255 : $b);

    // Converter de volta para hexadecimal
    $hex = "#" . str_pad(dechex($r), 2, "0", STR_PAD_LEFT) . str_pad(dechex($g), 2, "0", STR_PAD_LEFT) . str_pad(dechex($b), 2, "0", STR_PAD_LEFT);

    return $hex;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
  
<head>
    
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <meta http-equiv="Content-Language" content="pt-BR">
    <meta name="description" content="Prefeitura de S&#227;o Jos&#233; dos Campos">
    <meta name="author" content="Prefeitura de S&#227;o Jos&#233; dos Campos">
    <meta name="language" content="pt-BR">
    <meta name="classification" content="E-GOV">

    <link rel="shortcut icon" href="https://mogiguacu.sp.gov.br/images/favicon.ico" />

    <link href="css/stilo.css" rel="stylesheet"/>
    <link rel="stylesheet" href="css/tabler-icons.min.css">

    
    <script src="scripts/jquery-3.2.1.min.js"></script>    
    <script src="scripts/pmmg.js"></script>  


    <title>Serviços - Prefeitura Municipal de Mogi Guaçu</title>
    <meta name="keywords" content="Prefeitura, Cidade, Servi&#231;os, Online, S&#227;o Jos&#233; dos Campos" />
    
</head>
  <body>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC INICIO -->
    <header class="cabecalho-bg">
      <div class="cabecalho">
        <div class="logo">
          <div class="logo-img">
            <h1>
              <a href="https://www.sjc.sp.gov.br/" target="_top" id="Logotipo" onclick="trackEvent(this)">
                <img src="images/logoguacu.png" alt="Brasão - Prefeitura de São José dos Campos" width="290" height="72" />
              </a>
            </h1>
          </div>
        </div>
      </div>
      <div class="menu">
        <div class="topnav" id="myTopnav">
                    <a href="https://www.sjc.sp.gov.br/" accesskey="3" target="_top" class="btn" title="Home" id="Home" onclick="trackEvent(this)"> <i class="ti ti-home"></i> Home</a>
                    <a href="index.html" accesskey="5" target="_top" class="btn" title="Servi&#231;os" id="Servicos" onclick="trackEvent(this)"><i class="ti ti-file-description"></i> Diário Oficial</a>
                    <a href="https://www.sjc.sp.gov.br/noticias/" accesskey="1" target="_top" class="btn" title="Not&#237;cias" id="Noticias" onclick="trackEvent(this)"><i class="ti ti-message-circle"></i> e-SIC</a>
                    <a href="https://www.sjc.sp.gov.br/secretarias/" accesskey="6" target="_top" class="btn" title="Secretarias" id="Secretarias" onclick="trackEvent(this)"><i class="ti ti-headset"></i> Ouvidoria</a>
                    <a href="gestao-administrativa-e-financas/intranet/index.html" accesskey="4" target="_top" class="btn" title="Servidor" id="Servidor" onclick="trackEvent(this)"><i class="ti ti-school"></i> Portal da educação</a>
                    <a href="governanca/portal-da-transparencia/index.html" accesskey="7" target="_top" class="btn" title="Transpar&#234;ncia" id="Transparencia" onclick="trackEvent(this)"><i class="ti ti-brand-whatsapp"></i> Whats Débitos</a>                    
            <bottom href="javascript:void(0);" class="icon" onclick="menuTopo()">
                <span class="topnav-menu">Menu</span>
                <i class="fa fa-bars"></i>
            </bottom>
        </div>
    </div>
    </header>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC FIM -->
    <section class="conteudo-geral">
      <!-- SERVICOS -->
      <section>
        <div class="servicos_geral">
          <div class="barra_titulo_pesquisa_interna">
            <div class="titulo_pesquisa_interno"> SERVIÇOS </div>
            <div class="busca-interna">
              <form>
                <input name="pesquisa" class="input_pesquisa_interno" placeholder="ACHE O SERVIÇO QUE VOCÊ PROCURA" type="text" id="pesquisa-geral" required="required" pattern=".{3,}" title="Mínimo de 3 caracteres" />
                <input type="submit" value="BUSCAR" style="cursor:pointer" class="input_buscar_interno" />
              </form>
            </div>
          </div>
          <section>
            <div class="titulo_sections">
              <div class="titulo_sections_titulo">
                <span class='esconde_text_extra'>MAIS ACESSADOS</span>
              </div>
              <div class="titulo_sections_linha"></div>
              <div class="titulo_sections_botao_reduzido">
                <button onclick="location.href='https://www.sjc.sp.gov.br/servicos'" type="button" style="background: #ffffff00; border: none;" title="Mais serviços">
                  <img width="25" height="25" src="https://www.sjc.sp.gov.br/img/mais.svg" class="hover-img" alt="Mais serviços">
                </button>
              </div>
            </div>
            <div class="servicos">

              <div class="box-servicos">
                <a class="lserv" href="#" target="_self" id="castracao">
                  <div class="box-servicos-icone">
                    <div class="buttons" style="background: #d0a66c;">
                      <span style="width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url(images/uploads/1363618004.svg);filter: invert(100%) sepia(0%) saturate(0%) hue-rotate(306deg) brightness(104%) contrast(104%);"></span>
                    </div>
                  </div>
                  <div class="box-servicos-texto">
                    <div class="box-serv-t1">
                      <h2>Castracão</h2>
                    </div>
                    <div class='box-serv-t2'>
                      <h3>Serviço de agendamento de castração de animais</h3>
                    </div>
                  </div>
                </a>
              </div>



              <div class="box-servicos">
                <a class="lserv" href="gestao-administrativa-e-financas/iptu-e-tributos-de-imoveis/index.html" target="_self" id="IPTU_e_tributos_de_imoveis" onclick="trackEvent(this)">
                  <div class="box-servicos-icone">
                    <div class="buttons" style="background: #9e31a0;">
                      <span style="width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url(images/uploads/498616888.svg);filter: invert(100%) sepia(0%) saturate(7488%) hue-rotate(212deg) brightness(103%) contrast(105%);"></span>
                    </div>
                  </div>
                  <div class="box-servicos-texto">
                    <div class="box-serv-t1">
                      <h2>IPTU e tributos de im&#243;veis</h2>
                    </div>
                    <div class='box-serv-t2'>
                      <h3>IPTU 2024, ITBI, laudêmio, contribuição de melhoria</h3>
                    </div>
                  </div>
                </a>
              </div>

              <div class="box-servicos">
                <a class="lserv" href="gestao-administrativa-e-financas/protocolos-e-processos/consulta-de-processos/index.html" target="_blank" id="Consulta_de_processos" onclick="trackEvent(this)">
                  <div class="box-servicos-icone">
                    <div class="buttons" style="background: #509abe;">
                      <span style="width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url(images/uploads/459527718.svg);filter: invert(100%) sepia(5%) saturate(22%) hue-rotate(167deg) brightness(103%) contrast(100%);"></span>
                    </div>
                  </div>
                  <div class="box-servicos-texto">
                    <div class="box-serv-t1">
                      <h2>Consulta de processos</h2>
                    </div>
                    <div class='box-serv-t2'>
                      <h3>Acompanhe o andamento dos processos</h3>
                    </div>
                  </div>
                </a>
              </div>
              
              <div class="box-servicos">
                  <div class="box-servicos-icone">
                    <a href="https://mogiguacu.sp.gov.br/servicos/22/subsidio-de-transporte.html" target="_blank" onclick="handleClick(19)">
                      <div class="buttons" style="background: #1db985;">
                        <span style="width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url(images/uploads/1025436214.svg);filter: invert(100%) sepia(0%) saturate(7500%) hue-rotate(108deg) brightness(123%) contrast(110%);"></span>
                      </div>
                    </a>
                  </div>
                  <div class="box-servicos-texto">
                    <a href="apoio-juridico/consulta-de-assinatura-de-contratos/index.html" target="_blank">
                      <div class="int_box-serv-t1">
                        <h2> Subsídio de Transporte </h2>
                      </div>
                      <div class="box-serv-t2">
                        <h3> Subsídio de Transporte </h3>
                      </div>
                    </a>
                  </div>
               </div>
              
            </div>
          </section>
          <!-- SERVIÇOS -->
          <section>
              
            <?php
            
                $dbname = '../database/digital.db';
                
                try {
                    // Crie uma nova conexão SQLite PDO
                    $conn = new PDO("sqlite:$dbname");
                    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                
                    // Defina o charset como UTF-8 (não aplicável para SQLite, mas incluído para consistência)
                    $conn->exec("PRAGMA encoding = 'UTF-8';");
                
                    // Consulta para obter os grupos da tabela "grupo"
                    $sqlGrupos = "SELECT * FROM groups WHERE is_active = 1 ORDER BY (name = 'Zeladoria') DESC, name ASC";
                    $resultGrupos = $conn->query($sqlGrupos);
                
                    // Consulta para obter as imagens da tabela "botoes" com base no id_grupo
                    $sqlBotoes = "SELECT * FROM buttons WHERE id_group = :id_group AND is_active = 1";
                    $stmtBotoes = $conn->prepare($sqlBotoes);
                
                    // Exemplo de uso: botões de busca para grupo com id_group = 1
                    $id_group = 1;
                    $stmtBotoes->execute(array(':id_group' => $id_group));
                    $buttonsForGroup = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
                
                    // Exemplo de uso: botões de busca para grupo com id_group = 2
                    $id_group = 2;
                    $stmtBotoes->execute(array(':id_group' => $id_group));
                    $buttonsForGroup2 = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
    				
    				// Busque os dados dos objetos PDOStatement em arrays
    				$resultGruposArray = $resultGrupos->fetchAll(PDO::FETCH_ASSOC);
    				
    				
                
                    // Laço para imprimir os grupos e os botões relacinados a eles
                    if (count($resultGruposArray) > 0) {
                        foreach ($resultGruposArray as $rowGrupo) {
                            // Definir a cor inicial e a cor escura para este grupo
                            $corInicial = $rowGrupo["color"];
                            $corEscura = darkenColor($corInicial, 0.5); // Escurecer em 50%
                    
                            // Imprimir a div do grupo
                            
                            echo '<div id="2" class="int_servico_topico gradient-' . $rowGrupo["id_group"] . '" style="background-color:' . $corInicial . ' ; color:#fff; border-bottom:2px solid ' . $corEscura . '; display:flex;">';
                            	echo '<div class="serv_topico"> ' . $rowGrupo["name"] . ' </div>';
                            	echo '<div style="flex:.3; background:linear-gradient(to right bottom, ' . $corInicial . ' 50%, ' . $corEscura . ' 50%);"></div>';
                            	echo '<div class="serv_voltar_cor1 serv_voltar_cor_flex" style="background-color:' . $corEscura . '">';
                            		echo '<div class="serv_voltar_seta_img">';
                            			echo '<a href="#">';
                            				echo '<img src="https://www.sjc.sp.gov.br/img/seta_up.svg" alt="Voltar ao topo">';
                            			echo '</a>';
                            		echo '</div>';
                            		echo '<div class="serv_voltar_texto_link">';
                            			echo '<a href="#"> VOLTAR AO TOPO </a>';
                            		echo '</div>';
                                echo '</div>';   
                            echo '</div>';
                            
                            echo '<div class="int_servicos gradient-' . $rowGrupo["id_group"] . '">';
                            	echo '<fieldset class="fieldset-servicos" style="border-color:' . $corInicial . ' ">';
                            	    echo '<legend class="legend-fieldset-servicos" style="color:' . $corInicial . '">SERVI&#199;OS DA SECRETARIA</legend>';
                            	    echo '<div class="int_servicos_hotsite">';
                            
                            $stmtBotoes->execute(array(':id_group' => $rowGrupo["id_group"]));
                            $resultBotoesArray = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC); 
                            
                            $botaoRelacionado = false; // Variável de controle para verificar se há botões relacionados
                                                
                            foreach ($resultBotoesArray as $rowBotao) { 
                                $botaoRelacionado = true; // Há pelo menos um botão relacionado
                                    	echo '<div class="int_box-servicos">';
                                        	echo '<div class="int_box-servicos-icone">';
                                            	echo '<a href="' . $rowBotao["url"] . '" target="_blank" onclick="handleClick(' . $rowBotao["id_button"] . ')">'; // Abre a tag do link
                                            	echo '<div class="buttons" style="background: ' . $rowBotao["bgcolor"] . ';">';
                                            	$backgroundStyle = 'width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url(images/uploads/' . $rowBotao["icon"] . ');';
                                            	if (pathinfo($rowBotao["icon"], PATHINFO_EXTENSION) === 'svg') {
                                            		$backgroundStyle .= $rowBotao["iconcolor"];
                                            	} else {
                                            		$backgroundStyle .= 'width: 95%; height: 95%;';
                                            	}
                                            	echo '<span style="' . $backgroundStyle . '"></span>';
                                            	echo '</div>';    
                                            	echo '</a>'; // Fecha a tag do link
                                        	echo '</div>';
                                        	echo '<div class="int_box-servicos-texto">';
                                            	echo '<a href="apoio-juridico/consulta-de-assinatura-de-contratos/index.html" target="_blank">';
                                                	echo '<div class="int_box-serv-t1">';
                                                	    echo '<h2> ' . $rowBotao["label"] . ' </h2>';
                                                	echo '</div>';
                                                	echo '<div class="int_box-serv-t2">';                    
                                                	    echo '<h3> ' . $rowBotao["tags"] . ' </h3>';
                                                	echo '</div>';
                                            	echo '</a>';
                                        	echo '</div>';
                                    	echo '</div>';
                            	
                            	
                            }
                            
                            if (!$botaoRelacionado) {
                                // Se não houver botões relacionados, oculta a div do grupo
                                echo '<style>';
                                echo '.gradient-' . $rowGrupo["id_group"] . ' { display: none!important; }';
                                echo '</style>';
                            }
                            
                                    echo '</div>';
                                echo '</fieldset>';    
                            echo '</div>';
                            
                        }
                    } else {
                        echo "Nenhum grupo encontrado na tabela.";
                    }

                
                    // Feche a conexão com o banco de dados (opcional, pois o PDO fecha automaticamente quando o script termina)
                    $conn = null;
                } catch (PDOException $e) {
                    die("Connection failed: " . $e->getMessage());
                }
                ?> 
                
          </section>
          <!-- SERVIÇOS -->
        </div>
      </section>
      <!-- SERVICOS -->
    </section>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE INICIO -->
    <footer class="rodape">
      <div class="rodape-container">
        <div class="rodape-texto">
          <div class="end-rodape-1">Rua Henrique Coppi, nº 200 Centro <br />CEP: 13820-641 | +55 (19) 3851-7000 </div>
          <div class="end-rodape-2">Rua Henrique Coppi, nº 200 <br /> +55 (19) 3851-7000 </div>
        </div>
        <div class="rodape-brasao">
          <div class="rodape_brasao_img">
            <!--<img src="/img/brasao_branco.svg" alt="Brasão - Prefeitura de São José dos Campos" width="200" height="49"/>-->
            <img src="images/guacudigitalSTIBranco.png" alt="Guaçu Digital" width="120" height="52" />
          </div>
        </div>
        <div class="rodape-mapadosite">
          <a style="color:#fff;" href="index.html" target="_parent">Mapa do Site</a>
        </div>
      </div>
    </footer>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE FIM -->

    <script>
      function myFunction() {
          var x = document.getElementById("myTopnav");
          if (x.className === "topnav") {
            x.className += " responsive";
          } else {
            x.className = "topnav";
          }
        }
    </script>

    <script>
      function darkenColor(hex, percent) {
          // Remove "#" se estiver presente
          hex = hex.replace(/^\s*#|\s*$/g, '');
      
          // Converter para RGB
          var r = parseInt(hex.substring(0, 2), 16);
          var g = parseInt(hex.substring(2, 4), 16);
          var b = parseInt(hex.substring(4, 6), 16);
      
          // Escurecer a cor
          r = Math.floor(r * (1 - percent));
          g = Math.floor(g * (1 - percent));
          b = Math.floor(b * (1 - percent));
      
          // Garantir que os valores estejam dentro do intervalo [0, 255]
          r = (r < 0 || isNaN(r)) ? 0 : ((r > 255) ? 255 : r);
          g = (g < 0 || isNaN(g)) ? 0 : ((g > 255) ? 255 : g);
          b = (b < 0 || isNaN(b)) ? 0 : ((b > 255) ? 255 : b);
      
          // Converter de volta para hexadecimal
          var rr = (r.toString(16).length == 1 ? "0" + r.toString(16) : r.toString(16));
          var gg = (g.toString(16).length == 1 ? "0" + g.toString(16) : g.toString(16));
          var bb = (b.toString(16).length == 1 ? "0" + b.toString(16) : b.toString(16));
      
          // Retornar a cor em formato hexadecimal
          return "#" + rr + gg + bb;
      }
      
      // Definir a cor inicial
      var corInicial = "#38f2ff";
      document.documentElement.style.setProperty('--corInicial', corInicial);
      
      // Escurecer em 50%
      var corEscura = darkenColor(corInicial, 0.5);
      
      // Atualizar a propriedade CSS para a cor escura
      document.documentElement.style.setProperty('--corEscura', corEscura);
    </script>

</html>