<?php
    // Verificar se o ID do botão foi enviado através da requisição GET
    if (isset($_GET['buttonId'])) {
        // Obter o ID do botão da requisição GET
        $buttonId = $_GET['buttonId'];
    
        // Substitua 'seu_database.db' pelo caminho para o seu arquivo de banco de dados SQLite
        $dbname = '../database/digital.db';
    
        try {
            // Criar uma nova conexão PDO SQLite
            $conn = new PDO("sqlite:$dbname");
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
            // Atualizar o contador de cliques no banco de dados
            $stmt = $conn->prepare("UPDATE buttons SET clicks = clicks + 1 WHERE id_button = ?");
            $stmt->bindParam(1, $buttonId);
            $stmt->execute();
    
            // Fechar a conexão com o banco de dados
            $conn = null;
    
            // Responder à requisição AJAX com uma mensagem de sucesso
            echo "Clique registrado com sucesso.";
        } catch (PDOException $e) {
            // Em caso de erro, responder à requisição AJAX com uma mensagem de erro
            echo "Erro ao registrar o clique: " . $e->getMessage();
        }
    } else {
        // Se o ID do botão não foi enviado, responder à requisição AJAX com uma mensagem de erro
        echo "ID do botão não foi fornecido.";
    }
?>