<?php

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["pdfFile"])) {
    // Token de autenticação fornecido pelo DocuSeal
    $token = "xa4dkBdVmEbwjZurW4QqdiiigNnXvUASmo2hKZsgJtE";

    // URL da API do DocuSeal para criar templates a partir de PDFs
    $apiUrl = "https://assinador.mogiguacu.sp.gov.br/api/templates/pdf";

    // Caminho do arquivo temporário do PDF enviado
    $uploadedFile = $_FILES["pdfFile"]["tmp_name"];

    // Verifique se não houve erros no upload
    if ($_FILES["pdfFile"]["error"] == UPLOAD_ERR_OK) {
        // Obtenha o conteúdo do arquivo PDF
        $pdfContent = file_get_contents($uploadedFile);

        // Codifique o conteúdo do PDF em base64
        $base64Pdf = base64_encode($pdfContent);

        // Construa a carga útil JSON para a API do DocuSeal
        $jsonPayload = [
            "name" => "Test PDF",
            "documents" => [
                [
                    "name" => "string",
                    "file" => $base64Pdf,
                    "fields" => [
                        [
                            "name" => "Campo1",
                            "areas" => [
                                [
                                    "x" => 100, // Coordenada X do canto superior esquerdo da área de preenchimento
                                    "y" => 100, // Coordenada Y do canto superior esquerdo da área de preenchimento
                                    "w" => 200, // Largura da área de preenchimento
                                    "h" => 50,  // Altura da área de preenchimento
                                    "page" => 1 // Página do PDF onde está localizada a área de preenchimento
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        // Inicialize cURL
        $curl = curl_init();

        // Configure a requisição cURL para a API do DocuSeal
        curl_setopt_array($curl, [
            CURLOPT_URL => $apiUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($jsonPayload),
            CURLOPT_HTTPHEADER => [
                "X-Auth-Token: $token",
                "Content-Type: application/json"
            ],
        ]);

        // Execute a requisição cURL
        $response = curl_exec($curl);
        $err = curl_error($curl);

        // Verifique por erros na requisição
        if ($err) {
            echo "Erro cURL: " . $err;
        } else {
            // Exiba a resposta da API do DocuSeal
            echo "Resposta da API do DocuSeal: " . $response;
        }

        // Feche a sessão cURL
        curl_close($curl);

    } else {
        echo "Erro ao enviar o arquivo PDF.";
    }
} else {
    echo "Nenhum arquivo PDF enviado.";
}

?>
