<?php

    // Replace 'your_database.db' with the path to your SQLite database file
    //$dbname = '../database/digital.db';
    
    require ('dbconnection.php');
    
    require ('database/digital.php');
    
    //include('function.php');
    
     function get_total_all_records($conn)
    {
         $statement = $conn->prepare("SELECT * FROM buttons");
         $statement->execute();
         $result = $statement->fetchAll();
         return count($result);
    }
    
    try {
        
        // Create a new SQLite PDO connection
        //$conn = new PDO("sqlite:$dbname");
        //$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
        $query = '';
        $output = array();
        $query .= "SELECT buttons.*, groups.name FROM buttons LEFT JOIN groups ON buttons.id_group = groups.id_group ";
    
        if (isset($_POST["search"]["value"])) {
            $query .= 'WHERE label LIKE "%' . $_POST["search"]["value"] . '%" ';
            $query .= 'OR url LIKE "%' . $_POST["search"]["value"] . '%" ';
            $query .= 'OR name LIKE "%' . $_POST["search"]["value"] . '%" ';
        }
    
        if (isset($_POST["order"])) {
            $query .= 'ORDER BY ' . $_POST['order']['0']['column'] . ' ' . $_POST['order']['0']['dir'] . ' ';
        } else {
            $query .= 'ORDER BY id_button DESC ';
        }
    
        if ($_POST["length"] != -1) {
            $query .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
        }
    
        $statement = $conn->prepare($query);
        $statement->execute();
        $result = $statement->fetchAll();
        $data = array();
        $filtered_rows = count($result);
    
        foreach ($result as $row) {
            $image = '';
            if ($row["icon"] != '') {
                $image = '<img src="../images/uploads/' . $row["icon"] . '" class="img-thumbnail" width="50" height="35" />';
            }
    
            $sub_array = array();
            $sub_array[] = $image;
            $sub_array[] = $row["label"];
            $sub_array[] = $row["tags"];
            $sub_array[] = $row["url"];
            $sub_array[] = $row["name"];
            $sub_array[] = ($row["is_active"] == 1) ? 'Ativo' : 'Inativo'; // Adicionando o status do botao
            $sub_array[] = '<button type="button" name="update" id_button="' . $row["id_button"] . '" class="btn btn-warning btn-xs update">Atualizar</button>';
            $sub_array[] = '<button type="button" name="delete" id_button="' . $row["id_button"] . '" class="btn btn-danger btn-xs delete">Remover</button>';
            $data[] = $sub_array;
        }
    
        $output = array(
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $filtered_rows,
            "recordsFiltered" => get_total_all_records($conn),
            "data" => $data
        );
    
        echo json_encode($output);
    
        // Close the database connection (optional, as PDO closes automatically when the script ends)
        $conn = null;
    } catch (PDOException $e) {
        die("Connection failed: " . $e->getMessage());
    }
?>
