<?php
    
    require ('dbconnection.php');
    
    require ('database/digital.php');
    
    try {
        
        if (isset($_POST["id_button"])) {
            $output = array();
            $statement = $conn->prepare("SELECT * FROM buttons WHERE id_button = :id_button LIMIT 1");
            $statement->bindParam(':id_button', $_POST["id_button"], PDO::PARAM_INT);
            $statement->execute();
            $result = $statement->fetchAll();
    
            foreach ($result as $row) {
                $output["label"] = $row["label"];
                $output["tags"] = $row["tags"];
                $output["url"] = $row["url"];
                $output["bgcolor"] = $row["bgcolor"];
                $output["iconcolor"] = $row["iconcolor"];
                $output["id_group"] = $row["id_group"];
                $output["is_active"] = $row["is_active"];
    
                if ($row["icon"] != '') {
                    $output['icon'] = '<img src="../images/uploads/' . $row["icon"] . '" class="img-thumbnail" id="icon" width="50" height="35" /><input type="hidden" name="hidden_icon" value="' . $row["icon"] . '" />';
                } else {
                    $output['icon'] = '<input type="hidden" name="hidden_icon" value="" />';
                }
            }
    
            echo json_encode($output);
        }
    } catch (PDOException $e) {
        die("Connection failed: " . $e->getMessage());
    }
?>
