<?php

    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: index.php");
        exit;
    }
 
    // Define variables and initialize with empty values
    $username = $password = $confirm_password = "";
    $username_err = $password_err = $confirm_password_err = "";
    

?>

<html>
 <head>
  <title>Portal - Guaçu Digital - Admin</title>
  <script src="../js/jquery.min.js"></script>
  <link rel="stylesheet" href="../css/bootstrap.min.css" />
  <script src="../js/jquery.dataTables.min.js"></script>
  <script src="../js/dataTables.bootstrap.min.js"></script>  
  <link rel="stylesheet" href="../css/dataTables.bootstrap.min.css" />
  <script src="../js/bootstrap.min.js"></script>
  <style>
   body
   {
    margin:0;
    padding:0;
    background-color:#f1f1f1;
   }
   .box
   {
    width:1280px;
    padding:20px;
    background-color:#fff;
    border:1px solid #ccc;
    border-radius:5px;
    margin-top:25px;
   }
  </style>
 </head>
 <body>
  <div class="container box">
   <h1 align="center"></h1>
   <br />
   <div class="table-responsive">
    <br />
    <div align="right">
     <button type="button" id="add_user" data-toggle="modal" data-target="#userModal" class="btn btn-info btn-lg">Adicionar Usuario</button>     
    </div>
    <br /><br />

    <table id="user_data" class="table table-bordered table-striped">
     <thead>
      <tr>
       <th width="20%">Usuario</th>
       <th width="45%">Criado em:</th>      
       <th width="10%">Editar</th>
       <th width="10%">Remover</th>
      </tr>
     </thead>
    </table>
    
   </div>
  </div>
 </body>
</html>

<div id="userModal" class="modal fade">
 <div class="modal-dialog">
    <form method="post" id="user_form" enctype="multipart/form-data">

        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Adicionar Usuário</h4>
            </div>

            <div class="modal-body">

            <label>Usuário</label>
            <input type="text" name="username" id="username" class="form-control">
            <span id="username_err" class="invalid-feedback"></span>
            <br/>

            <label>Password</label>
            <input type="password" name="password" id="password" class="form-control">
            <span id="password_err" class="invalid-feedback"></span>
            <br/>

            <label>Confirm Password</label>
            <input type="password" name="confirm_password" id="confirm_password" class="form-control">
            <span id="confirm_password_err" class="invalid-feedback"></span>
            <br/>


            </div>

            <div class="modal-footer">
				<input type="hidden" name="id_user" id="id_user" />
                <input type="hidden" name="original_username" id="original_username" />
				<input type="hidden" name="operation" id="operation" />
				<input type="submit" name="action" id="action" class="btn btn-success" value="Add" />
				<button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
			</div>

        </div>

    </form>
 </div>
</div>

<script type="text/javascript" language="javascript" >
$(document).ready(function(){ 

    $('#add_user').click(function(){
        $('#user_form')[0].reset();
        $('.modal-title').text("Adicionar Usuário");
        $('#action').val("add");
        $('#operation').val("Add");  
    });

    $(document).on('submit', '#user_form', function(event){
        event.preventDefault();
        var user = $('#user').val();
        var usercolor = $('#usercolor').val();
        
        
        if(user != '' && usercolor != ''){
            $.ajax({
                url:"userInsert.php",
                method:'POST',
                data:new FormData(this),
                contentType:false,
                processData:false,
                success: function(data) {

                    var data = JSON.parse(data);

                    if (data.success) {
                        alert(data.message);
                        $('#user_form')[0].reset();
                        $('#userModal').modal('hide');
                        dataTable.ajax.reload();
                    } else {
                        // Clear existing error classes and messages
                        $('#username').removeClass('is-invalid');
                        $('#username_err').text('');
                        $('#password').removeClass('is-invalid');
                        $('#password_err').text('');
                        $('#confirm_password').removeClass('is-invalid');
                        $('#confirm_password_err').text('');

                        // Check for error messages for username
                        if (data.error_messages && data.error_messages.username_err) {
                            $('#username').addClass('is-invalid');
                            $('#username_err').text(data.error_messages.username_err).css('color', 'red');
                        }

                        // Check for error messages for password
                        if (data.error_messages && data.error_messages.password_err) {
                            $('#password').addClass('is-invalid');
                            $('#password_err').text(data.error_messages.password_err).css('color', 'red');
                        }

                        // Check for error messages for confirm password
                        if (data.error_messages && data.error_messages.confirm_password_err) {
                            $('#confirm_password').addClass('is-invalid');
                            $('#confirm_password_err').text(data.error_messages.confirm_password_err).css('color', 'red');
                        }
                    }
                }
            });
        }else {
            alert("Ambos os campos são necessários");
        }
    });


    var dataTable = $('#user_data').DataTable({
        "processing":true,
        "serverSide":true,
        "order":[],
        "ajax":{
            url:"userFetch.php",
            type:"POST"
        },
        "columnDefs":[
        {
            "targets":[2, 3],
            "orderable":false,
        },
        ],

    });

    
    $(document).on('click', '.update', function(){
        var id_user = $(this).attr("id_user");
        $.ajax({
            url:"userFetch_single.php",
            method:"POST",
            data:{id_user:id_user},
            dataType:"json",
            success:function(data)
            {
                $('#userModal').modal('show');
                $('#username').val(data.username);
                $('#original_username').val(data.username);               
                $('.modal-title').text("Editar Usuário");
                $('#id_user').val(id_user);    
                $('#action').val("Edit");
                $('#operation').val("Edit");
            }
        })
    });

    
    $(document).on('click', '.delete', function(){

        var id_user = $(this).attr("id_user");
        
        if(confirm("Are you sure you want to delete this?")){
            $.ajax({
                url: "userDelete.php",
                method: "POST",
                data: { id_user: id_user },
                success: function(data) {
                    alert(data);
                    dataTable.ajax.reload();
                }
            });
        }else {
            return false; 
        }
    });
 
 
});
</script>