<?php

// Função para escurecer uma cor em hexadecimal

function darkenColor($hex, $percent) {
    // Remover "#" se estiver presente
    $hex = str_replace("#", "", $hex);

    // Converter para RGB
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));

    // Escurecer a cor
    $r = round($r * (1 - $percent));
    $g = round($g * (1 - $percent));
    $b = round($b * (1 - $percent));

    // Garantir que os valores estejam dentro do intervalo [0, 255]
    $r = ($r < 0 || is_nan($r)) ? 0 : (($r > 255) ? 255 : $r);
    $g = ($g < 0 || is_nan($g)) ? 0 : (($g > 255) ? 255 : $g);
    $b = ($b < 0 || is_nan($b)) ? 0 : (($b > 255) ? 255 : $b);

    // Converter de volta para hexadecimal
    $hex = "#" . str_pad(dechex($r), 2, "0", STR_PAD_LEFT) . str_pad(dechex($g), 2, "0", STR_PAD_LEFT) . str_pad(dechex($b), 2, "0", STR_PAD_LEFT);

    return $hex;
}

?>

<!DOCTYPE html>
<html lang="pt-BR">
  
<head>
    
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <meta http-equiv="Content-Language" content="pt-BR">
    <meta name="description" content="Serviços - Prefeitura Municipal de Mogi Guaçu">
    <meta name="author" content="Secretarria de Tecnologia e Inovação - Departamento de Tecnologia">
    <meta name="language" content="pt-BR">
    <meta name="classification" content="E-GOV">

    <link rel="shortcut icon" href="https://mogiguacu.sp.gov.br/images/favicon.ico" />

    <link href="css/stilo.css" rel="stylesheet"/>
    <link rel="stylesheet" href="css/lgpd.css">
    <link rel="stylesheet" href="css/tabler-icons.min.css">
    
    <script src="js/jquery-3.2.1.min.js"></script>    
    <script src="js/pmmg.js"></script>  

    <title>Serviços - Prefeitura Municipal de Mogi Guaçu</title>
    <meta name="keywords" content="Prefeitura Municipal de Mogi Guaçu, Guaçu Digital" />
    
    <style>
      .grupo {
        margin: 0 auto;
        max-width: 960px;
        /* min-height: 80px; */
        display: flex;
        flex-wrap: wrap;
        margin-bottom: 10px;
        }
        #myBtn {
            display: none; /* Começa escondido */
            align-items: center; 
            position: fixed;
            bottom: 5px; /* Alterado para 5px do fundo */
            right: 3px;
            z-index: 99;
            font-size: 16px;
            border: none;
            outline: none;
            background-color: red;
            color: white;
            cursor: pointer;
            padding: 15px;
            border-radius: 4px;
            transition: bottom 0.3s; /* Adicionado para suavizar a transição */
        }
      
        #myBtn:hover {
            background-color: #555;
        }
    </style>
    
</head>
  <body>
      
        <button onclick="topFunction()" id="myBtn" title="Go to top">
            <div class="serv_voltar_seta_img">
                <img src="images/seta_up.svg" alt="Voltar ao topo">
            </div>
            <div class="serv_voltar_texto_link">
                VOLTAR AO TOPO
            </div>
        </button>
      
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC INICIO -->
    <header class="cabecalho-bg">
        <div class="cabecalho">
            <div class="logo">
              <div class="logo-img">
                <h1>
                  <a href="https://digital.mogiguacu.sp.gov.br" target="_top" id="Logotipo" onclick="trackEvent(this)">
                    <img src="images/logoguacu.png" alt="Prefeitura Municipal de Mogi Guaçu" width="290" height="72" />
                  </a>
                </h1>
              </div>
              <!-- MIDIAS SOCIAIS -->
                <div class="home-barra-midias-sociais-not">
                    <div class="home-barra-midias-sociais-not-interna ">
                        <div class="home-barra-midias-sociais-item-not">
                            <a href="https://www.facebook.com/PrefeituradeMogiGuacu" target="_blank" rel="noopener noreferer">
                                <img src="../images/facebook.svg" class="hover-img1 midias-aling img-upresp" title="Facebook" alt="Facebook" id="Facebook" onclick="trackEvent(this)" width="20" height="20">
                            </a>
                        </div>
                        <div class="home-barra-midias-sociais-item-not">
                            <a href="https://www.instagram.com/prefeituramogiguacu/" target="_blank" rel="noopener noreferer">
                                <img src="../images/instagram.svg" class="hover-img1 midias-aling img-upresp" title="Instagram" alt="Instagram" id="Instagram" onclick="trackEvent(this)" width="20" height="20">
                            </a>
                        </div>
                        <div class="home-barra-midias-sociais-item-not">
                            <a href="https://www.youtube.com/channel/UCAMlQ4bD01ZEuYzODJI56Rg" target="_blank" rel="noopener noreferer">
                                <img src="../images/youtube.svg" class="hover-img1 midias-aling img-upresp" title="YouTube" alt="YouTube" id="YouTube" onclick="trackEvent(this)" width="20" height="20">
                            </a>
                        </div>
                    </div>
                </div>
            <!-- MIDIAS SOCIAIS -->
            </div>
        </div>
        <div class="menu">
            <div class="topnav" id="myTopnav">
                        <a href="/index.php" target="_top" class="btn" title="Home" id="Home"> <i class="ti ti-home"></i> Home</a>
                        <a href="https://mogiguacu.sp.gov.br/diario.html" target="_blank" class="btn" title="Diário Oficial"><i class="ti ti-file-description"></i> Diário Oficial</a>
                        <a href="https://gpmodmogiguacu.intertecsolucoes.com.br/GPMODMGG/f?p=205:100210:::::P0_ENTIDADE:1" target="_blank" class="btn" title="e-SIC"><i class="ti ti-message-circle"></i> e-SIC</a>
                        <a href="https://gpmodmogiguacu.intertecsolucoes.com.br/GPMODMGG/f?p=205:100110:::::P0_ENTIDADE:1" target="_blank" class="btn" title="Ouvidoria"><i class="ti ti-headset"></i> Ouvidoria</a>
                        <a href="http://mogiguacu.educaon.com.br/" accesskey="4" target="_blank" class="btn" title="Portal da educação" id="Servidor" onclick="trackEvent(this)"><i class="ti ti-school"></i> Portal da educação</a>
                        <a href="https://api.whatsapp.com/send?l=pt&phone=5519971349546&text=Gostaria%20de%20saber%20sobre%20meus%20d%C3%A9bitos" target="_blank" class="btn" title="Whats Débitos"><i class="ti ti-brand-whatsapp"></i> Whats Débitos</a>                    
                <bottom href="javascript:void(0);" class="icon" onclick="menuTopo()">
                    <span class="topnav-menu">Menu</span>
                    <i class="fa fa-bars"></i>
                </bottom>
            </div>
        </div>
    </header>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC FIM -->
    <section class="conteudo-geral">
      <!-- SERVICOS -->
      <section>
        <div class="servicos_geral">
          <div class="barra_titulo_pesquisa_interna">
            <div class="titulo_pesquisa_interno"> SERVIÇOS </div>
            <div class="busca-interna">
              <form>
                <input name="pesquisa" class="input_pesquisa_interno" placeholder="ACHE O SERVIÇO QUE VOCÊ PROCURA" type="text" id="searchInput" required="required" pattern=".{3,}" title="Mínimo de 3 caracteres" />
                <input type="submit" value="BUSCAR" style="cursor:pointer" class="input_buscar_interno" />
              </form>
            </div>
          </div>
          <section>
              <div id="grupo" class="grupo dp100"></div>
          </section>
          <section>
            <div class="titulo_sections">
              <div class="titulo_sections_titulo">
                <span class='esconde_text_extra'>MAIS ACESSADOS</span>
              </div>
              <div class="titulo_sections_linha"></div>
            </div>
            <div class="servicos">

                <?php
                
                    //Base URL
                    $baseurl = "https://digital.mogiguacu.sp.gov.br/";
                
                    // Caminho para o arquivo do banco de dados SQLite
                    $dbname = 'admin/database/digital.db';
                    
                    try {
                        // Crie uma nova conexão SQLite PDO
                        $conn = new PDO("sqlite:$dbname");
                        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                    
                        // Defina o charset como UTF-8 (não aplicável para SQLite, mas incluído para consistência)
                        $conn->exec("PRAGMA encoding = 'UTF-8';");
                        
                        $sqlBotoesMaisClicados = "SELECT * FROM buttons WHERE is_active = 1 ORDER BY clicks DESC LIMIT 9";
                        $stmtBotoesMaisClicados = $conn->prepare($sqlBotoesMaisClicados);
                        $stmtBotoesMaisClicados->execute();
                        $resultBotoesMaisClicados = $stmtBotoesMaisClicados->fetchAll(PDO::FETCH_ASSOC);
                    
                        // Agora você pode imprimir os 9 botões mais clicados
                        foreach ($resultBotoesMaisClicados as $rowBotao) {
                            echo '<div class="box-servicos">';
                            echo '<a class="lserv" href="' . $rowBotao["url"] . '" target="_blank" id="' . $rowBotao["id_button"] . '" onclick="handleClick(' . $rowBotao["id_button"] . ')">';
                            echo '<div class="box-servicos-icone">';
                            echo '<div class="buttons" style="background: ' . $rowBotao["bgcolor"] . ';">';
                            $backgroundStyle = 'width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url('. $baseurl .'images/uploads/' . $rowBotao["icon"] . ');';
                            if (pathinfo($rowBotao["icon"], PATHINFO_EXTENSION) === 'svg') {
                                $backgroundStyle .= $rowBotao["iconcolor"];
                            } else {
                                $backgroundStyle .= 'width: 95%; height: 95%;';
                            }
                            echo '<span style="' . $backgroundStyle . '"></span>';
                            echo '</div>';
                            echo '</div>';
                            echo '<div class="box-servicos-texto">';
                            echo '<div class="box-serv-t1">';
                            echo '<h2>' . $rowBotao["label"] . '</h2>';
                            echo '</div>';
                            echo '<div class="box-serv-t2">';
                            echo '<h3>' . $rowBotao["tags"] . '</h3>';
                            echo '</div>';
                            echo '</div>';
                            echo '</a>';
                            echo '</div>';
                        }
                    
                        
                        $conn = null;
                    } catch (PDOException $e) {
                        // Em caso de erro na conexão ou em alguma operação com o banco de dados, você pode lidar com isso aqui
                        die("Connection failed: " . $e->getMessage());
                    }
                ?>
              
            </div>
          </section>
          <!-- SERVIÇOS -->
          <section>
              
            <?php
            
                //Base URL
                $baseurl = "https://digital.mogiguacu.sp.gov.br/";
            
                // Caminho para o arquivo do banco de dados SQLite
                $dbname = 'admin/database/digital.db';
                
                try {
                    // Crie uma nova conexão SQLite PDO
                    $conn = new PDO("sqlite:$dbname");
                    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                
                    // Defina o charset como UTF-8 (não aplicável para SQLite, mas incluído para consistência)
                    $conn->exec("PRAGMA encoding = 'UTF-8';");
                
                    // Consulta para obter os grupos da tabela "grupo"
                    $sqlGrupos = "SELECT * FROM groups WHERE is_active = 1 ORDER BY (name = 'Zeladoria') DESC, name ASC";
                    $resultGrupos = $conn->query($sqlGrupos);
                
                    // Consulta para obter as imagens da tabela "botoes" com base no id_grupo
                    $sqlBotoes = "SELECT * FROM buttons WHERE id_group = :id_group AND is_active = 1";
                    $stmtBotoes = $conn->prepare($sqlBotoes);
                
                    // Exemplo de uso: botões de busca para grupo com id_group = 1
                    $id_group = 1;
                    $stmtBotoes->execute(array(':id_group' => $id_group));
                    $buttonsForGroup = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
                
                    // Exemplo de uso: botões de busca para grupo com id_group = 2
                    $id_group = 2;
                    $stmtBotoes->execute(array(':id_group' => $id_group));
                    $buttonsForGroup2 = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
    				
    				// Busque os dados dos objetos PDOStatement em arrays
    				$resultGruposArray = $resultGrupos->fetchAll(PDO::FETCH_ASSOC);
    				
    				
                
                    // Laço para imprimir os grupos e os botões relacinados a eles
                    if (count($resultGruposArray) > 0) {
                        foreach ($resultGruposArray as $rowGrupo) {
                            // Definir a cor inicial e a cor escura para este grupo
                            $corInicial = $rowGrupo["color"];
                            $corEscura = darkenColor($corInicial, 0.5); // Escurecer em 50%
                    
                            // Imprimir a div do grupo
                            
                            echo '<div id="2" class="int_servico_topico gradient-' . $rowGrupo["id_group"] . '" style="background-color:' . $corInicial . ' ; color:#fff; border-bottom:2px solid ' . $corEscura . '; display:flex;">';
                            	echo '<div class="serv_topico"> ' . $rowGrupo["name"] . ' </div>';
                            	echo '<div style="flex:.3; background:linear-gradient(to right bottom, ' . $corInicial . ' 50%, ' . $corEscura . ' 50%);"></div>';
                            	echo '<div class="serv_voltar_cor1 serv_voltar_cor_flex" style="background-color:' . $corEscura . '">';
                            	//	echo '<div class="serv_voltar_seta_img">';
                            	//		echo '<a href="#">';
                            	//			echo '<img src="images/seta_up.svg" alt="Voltar ao topo">';
                            	//		echo '</a>';
                            	//	echo '</div>';
                            	//	echo '<div class="serv_voltar_texto_link">';
                            	//		echo '<a href="#"> VOLTAR AO TOPO </a>';
                            	//	echo '</div>';
                                echo '</div>';   
                            echo '</div>';
                            
                            echo '<div class="int_servicos gradient-' . $rowGrupo["id_group"] . '">';
                            	echo '<fieldset class="fieldset-servicos" style="border-color:' . $corInicial . ' ">';
                            	    //echo '<legend class="legend-fieldset-servicos" style="color:' . $corInicial . '">SERVI&#199;OS DA SECRETARIA</legend>';
                            	    echo '<div class="int_servicos_hotsite">';
                            
                            $stmtBotoes->execute(array(':id_group' => $rowGrupo["id_group"]));
                            $resultBotoesArray = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC); 
                            
                            $botaoRelacionado = false; // Variável de controle para verificar se há botões relacionados
                                                
                            foreach ($resultBotoesArray as $rowBotao) { 
                                $botaoRelacionado = true; // Há pelo menos um botão relacionado
                                    	echo '<div class="int_box-servicos">';
                                        	echo '<div class="int_box-servicos-icone">';
                                            	echo '<a href="' . $rowBotao["url"] . '" target="_blank" onclick="handleClick(' . $rowBotao["id_button"] . ')">'; // Abre a tag do link
                                            	echo '<div class="buttons" style="background: ' . $rowBotao["bgcolor"] . ';">';
                                            	$backgroundStyle = 'width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url('. $baseurl .'images/uploads/' . $rowBotao["icon"] . ');';
                                            	if (pathinfo($rowBotao["icon"], PATHINFO_EXTENSION) === 'svg') {
                                            		$backgroundStyle .= $rowBotao["iconcolor"];
                                            	} else {
                                            		$backgroundStyle .= 'width: 95%; height: 95%;';
                                            	}
                                            	echo '<span style="' . $backgroundStyle . '"></span>';
                                            	echo '</div>';    
                                            	echo '</a>'; // Fecha a tag do link
                                        	echo '</div>';
                                        	echo '<div class="int_box-servicos-texto">';
                                            	echo '<a href="' . $rowBotao["url"] . '" target="_blank">';
                                                	echo '<div class="int_box-serv-t1">';
                                                	    echo '<h2> ' . $rowBotao["label"] . ' </h2>';
                                                	echo '</div>';
                                                	echo '<div class="int_box-serv-t2">';                    
                                                	    echo '<h3> ' . $rowBotao["tags"] . ' </h3>';
                                                	echo '</div>';
                                            	echo '</a>';
                                        	echo '</div>';
                                    	echo '</div>';
                            }
                            
                            if (!$botaoRelacionado) {
                                // Se não houver botões relacionados, oculta a div do grupo
                                echo '<style>';
                                echo '.gradient-' . $rowGrupo["id_group"] . ' { display: none!important; }';
                                echo '</style>';
                            }
                            
                                    echo '</div>';
                                echo '</fieldset>';    
                            echo '</div>';
                            
                        }
                    } else {
                        echo "Nenhum grupo encontrado na tabela.";
                    }

                
                    // Feche a conexão com o banco de dados (opcional, pois o PDO fecha automaticamente quando o script termina)
                    $conn = null;
                } catch (PDOException $e) {
                    die("Connection failed: " . $e->getMessage());
                }
                ?> 
                
          </section>
          <!-- SERVIÇOS -->
        </div>
      </section>
      <!-- SERVICOS -->
    </section>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE INICIO -->
    <footer class="rodape">
      <div class="rodape-container">
        <div class="rodape-texto">
          <div class="end-rodape-1">Rua Henrique Coppi, nº 200 Centro <br />CEP: 13820-641 | +55 (19) 3851-7000 </div>
          <div class="end-rodape-2">Rua Henrique Coppi, nº 200 <br /> +55 (19) 3851-7000 </div>
        </div>
        <div class="rodape-brasao">
          <div class="rodape_brasao_img">
            <img src="images/guacudigitalSTIBranco.png" alt="Guaçu Digital" width="127" height="50" />
          </div>
        </div>
        <div class="rodape-mapadosite">
                Secretaria de Tecnologia e Inovação
            </br>
                Departamento de Tecnologia
            </br>
                2024
        </div>
      </div>
      <div style="text-align: center; width: 100%;">
            <a style="color: #fff;font-family: MyriadPro;" href="politica-de-privacidade-e-termo-de-uso.html" target="_blank">Política de privacidade</a>
        </div>
    </footer>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE FIM -->
    
    <!-- Janela de Verificação do Cookie -->
    <div id="janela-aviso">
        <span class="close-lgpd">&times;</span>
        <div class="modal-body">
            <p>Usamos cookies para tornar sua experiencia a mais agradável possível.</p>
            <p>Se continuar navegando neste site, você assume concordar com nossa,  
            <a href="politica-de-privacidade-e-termo-de-uso.html" target="_blank">POLÍTICA DE COOKIES E REGISTRO DE NAVEGAÇÃO</a>.</p>
        </div>
        <div align="center" style="margin-top: 10px;">
            <button class="btn-lgpd" id="btnAceiteLGPD">Entendi e aceito</button>
        </div>
    </div>
    <!-- Fim da Janela de Verificação do Cookie -->
    
    <script src="js/lgpd.js"></script>
    
    <script>
      let mybutton = document.getElementById("myBtn");
    
      window.onscroll = function() {scrollFunction()};
    
      function scrollFunction() {
        if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
          mybutton.style.display = "flex";
        } else {
          mybutton.style.display = "none";
        }
        
        if ((window.innerHeight + window.pageYOffset) >= document.body.offsetHeight - 80) {
          if (window.innerWidth < 768) {
            // Se a largura da janela for menor que 768px e estiver próximo ao final da página
            mybutton.style.bottom = "212px";
          } else {
            // Se a largura da janela for maior ou igual a 768px e estiver próximo ao final da página
            mybutton.style.bottom = "98px";
          }
        } else {
          mybutton.style.bottom = "5px";
        }
      }
    
      function topFunction() {
        document.body.scrollTop = 0;
        document.documentElement.scrollTop = 0;
      }
    </script>

    
    <script>
        function handleClick(buttonId) {
            // Enviar o ID do botão clicado para o servidor
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    // O código aqui será executado quando a requisição AJAX for concluída com sucesso
                    console.log("Clique registrado com sucesso.");
                }
            };
            xhttp.open("GET", "registrar_clique.php?buttonId=" + buttonId, true);
            xhttp.send();
        }
    </script>
        
    <script>
        document.addEventListener("DOMContentLoaded", function () {
          const searchInput = document.getElementById("searchInput");
          const intBoxServicos = document.querySelectorAll(".int_box-servicos");
          const grupoContainer = document.getElementById("grupo");
        
          function filterIntBoxServicos() {
            const searchTerm = searchInput.value.trim().toLowerCase();
            grupoContainer.innerHTML = ''; // Limpa o conteúdo anterior
        
            if (searchTerm === "") {
              return; // Não faz nada se o campo de busca estiver vazio
            }
        
            intBoxServicos.forEach(function (intBox) {
              const h2Text = intBox.querySelector("h2").textContent.toLowerCase();
              const h3Text = intBox.querySelector("h3").textContent.toLowerCase();
        
              if (h2Text.includes(searchTerm) || h3Text.includes(searchTerm)) {
                const clonedBox = intBox.cloneNode(true);
                grupoContainer.appendChild(clonedBox); // Adiciona o box correspondente ao grupoContainer
              }
            });
          }
        
          searchInput.addEventListener("input", filterIntBoxServicos);
        });

    </script>

</html>