<?php
    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: index.php");
        exit;
    }
?>

<!DOCTYPE html>
<html>
<head>
    <title>Guaçu digital - Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="css/admin.css" />
    <style type="text/css">
        body {
            padding-top: 20px;
            background: #eee;
        }

        .panel-body .btn:not(.btn-block) {
            width: 120px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>



<div class="container bootstrap snippets bootdey">
    <h4 class="my-5">Olá, <b><?php echo htmlspecialchars($_SESSION["username"]); ?></b>. Bem-vindo ao nosso site.</h4>
<p>
	<!--  <a href="reset-password.php" class="btn btn-warning">Redefinir sua senha</a> -->
	<a href="logout.php" class="btn btn-danger ml-3">Desconectar da sua conta</a>
</p>
</div>

<div class="container bootstrap snippets bootdey">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h3 class="panel-title">
                        <span class="glyphicon glyphicon-bookmark"></span> Acesso rápido
                    </h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-6">
                            <a href="groups.php" class="btn btn-danger btn-lg btn-block" role="button" target="_blank"><span class="glyphicon glyphicon-list-alt"></span> <br/>Grupos</a>
                            <a href="buttons.php" class="btn btn-warning btn-lg btn-block" role="button" target="_blank"><span class="glyphicon glyphicon-bookmark"></span> <br/>Botões</a>
                            <a href="pages.php" class="btn btn-primary btn-lg btn-block" role="button" target="_blank"><span class="glyphicon glyphicon-file"></span> <br/>Páginas</a>
                            <a href="users.php" class="btn btn-success btn-lg btn-block" role="button" target="_blank"><span class="glyphicon glyphicon-user"></span> <br/>Usuários</a>
                            </br>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-6">
                            <a href="#" class="btn btn-success btn-lg btn-block" role="button"><span class="glyphicon glyphicon-user"></span> <br/>Users</a>
                            <a href="#" class="btn btn-info btn-lg btn-block" role="button"><span class="glyphicon glyphicon-file"></span> <br/>Notes</a>
                            <a href="#" class="btn btn-primary btn-lg btn-block" role="button"><span class="glyphicon glyphicon-picture"></span> <br/>Photos</a>
                            <a href="#" class="btn btn-primary btn-lg btn-block" role="button"><span class="glyphicon glyphicon-tag"></span> <br/>Tags</a>
                            </br>
                        </div>
                    </div>
                    <a href="../index.php" class="btn btn-success btn-lg btn-block" role="button" target="_blank"><span class="glyphicon glyphicon-globe"></span> Website</a>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="../js/jquery.min.js"></script>
<script src="../js/bootstrap.min.js"></script>
<script src="../js/jquery.dataTables.min.js"></script>
<script src="../js/dataTables.bootstrap.min.js"></script>

</body>
</html>