<?php

    require ('dbconnection.php');
    
    require ('database/digital.php');
    
    function get_image_name($conn, $id_button)
    {
        try {
    
            $statement = $conn->prepare("SELECT icon FROM buttons WHERE id_button = :id_button");
            $statement->bindParam(':id_button', $id_button, PDO::PARAM_INT);
            $statement->execute();
            $result = $statement->fetchAll();
            
            foreach ($result as $row) {
                return $row["icon"];
                
            }
    
            // Close the database connection (optional, as PDO closes automatically when the script ends)
            //$conn = null;
        } catch (PDOException $e) {
            echo "get_image_name (falha na conexao): " . $e->getMessage();
        }
    }
    
    
    if (isset($_POST["id_button"])) {
        
        $image = get_image_name($conn, $_POST["id_button"]);
        
        if ($image != '') {
            unlink("../images/uploads/" . $image);
        }
    
        // Call the function to delete data from the buttons table
        deleteButtonData($conn, $_POST["id_button"]);
    
        echo 'Botao apagado com sucesso!';
    }
    
    // Close the database connection
    $database->close();
?>