<?php

   // Replace 'your_database.db' with the path to your SQLite database file
   $database = new SQLite3('database/digital.db');
    
    // Function to create tables if they don't exist
    function createTables($database) {
        $createButtonsTable = "CREATE TABLE IF NOT EXISTS buttons (
            id_button INTEGER PRIMARY KEY AUTOINCREMENT,
            icon TEXT NOT NULL,
            iconcolor TEXT NOT NULL,
            bgcolor TEXT NOT NULL,
            label TEXT NOT NULL,
            tags TEXT NOT NULL,
            url TEXT NOT NULL,
            id_group INTEGER NOT NULL,
            is_active INTEGER,
            clicks	INTEGER DEFAULT 0
        );";
        
        
        $createPagesTable = "CREATE TABLE IF NOT EXISTS pages (
            id_page INTEGER PRIMARY KEY AUTOINCREMENT,
            pagename TEXT NOT NULL,
            pagegroup INTEGER NOT NULL,
            pagecontent TEXT NOT NULL,
            page_icon INTEGER NOT NULL,
            is_active INTEGER NOT NULL
        );";
        
        
        $createGroupsTable = "CREATE TABLE IF NOT EXISTS groups (
            id_group INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT NOT NULL,
            color TEXT NOT NULL,
            is_active INTEGER 
        );";
        
        $createUsersTable = "CREATE TABLE IF NOT EXISTS users (
            id_user INTEGER PRIMARY KEY AUTOINCREMENT,
            username TEXT NOT NULL,
            password TEXT NOT NULL,
            is_active INTEGER, 
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        );";
        
        $database->exec($createButtonsTable);
        $database->exec($createPagesTable);
        $database->exec($createGroupsTable);
        $database->exec($createUsersTable);
    }
    
    //buttons fuctions:
    
    // Function to insert data into the buttons table
    function insertButtonData($conn, $icon, $label, $tags, $shorttext, $url,  $bgcolor, $iconcolor, $id_group, $is_active) {
        $stmt = $conn->prepare("INSERT INTO buttons (icon, label, tags, shorttext, url, bgcolor, iconcolor, id_group, is_active, clicks) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 0)");
        $stmt->bindValue(1, $icon);
        $stmt->bindValue(2, $label);
        $stmt->bindValue(3, $tags);
        $stmt->bindValue(4, $shorttext);
        $stmt->bindValue(5, $url);
        $stmt->bindValue(6, $bgcolor);
        $stmt->bindValue(7, $iconcolor);
        $stmt->bindValue(8, $id_group);
        $stmt->bindValue(9, $is_active);
        $stmt->execute();
        
        // Return the ID of the inserted button
        return $conn->lastInsertId();
        
    }
    
    // // Function to update data in the buttons table
    // function updateButtonData($conn, $icon, $label, $tags, $url, $bgcolor, $iconcolor, $id_group, $is_active, $id_button, $clicks) {
    //     $stmt = $conn->prepare("UPDATE buttons SET icon=?, label=?, tags=?, url=?, bgcolor=?, iconcolor=?, id_group=?, is_active=?, clicks=? WHERE id_button=?;");
    //     $stmt->bindValue(1, $icon);
    //     $stmt->bindValue(2, $label);
    //     $stmt->bindValue(3, $tags);
    //     $stmt->bindValue(4, $url);
    //     $stmt->bindValue(5, $bgcolor);
    //     $stmt->bindValue(6, $iconcolor);
    //     $stmt->bindValue(7, $id_group);
    //     $stmt->bindValue(8, $is_active);
    //     $stmt->bindValue(9, $clicks);
    //     $stmt->bindValue(10, $id_button);
    //     $stmt->execute();
    // }
    
    // Function to update data in the buttons table
    function updateButtonData($conn, $icon, $label, $tags, $shorttext, $url,  $bgcolor, $iconcolor, $id_group, $is_active, $id_button) {
        $stmt = $conn->prepare("UPDATE buttons SET icon=?, label=?, tags=?, shorttext=?, url=?, bgcolor=?, iconcolor=?, id_group=?, is_active=? WHERE id_button=?;");
        $stmt->bindValue(1, $icon);
        $stmt->bindValue(2, $label);
        $stmt->bindValue(3, $tags);
        $stmt->bindValue(4, $shorttext);
        $stmt->bindValue(5, $url);
        $stmt->bindValue(6, $bgcolor);
        $stmt->bindValue(7, $iconcolor);
        $stmt->bindValue(8, $id_group);
        $stmt->bindValue(9, $is_active);
        $stmt->bindValue(10, $id_button);
        $stmt->execute();
    }
    
    // Function to delete data from the buttons table
    function deleteButtonData($conn, $buttonId) {
        
        try{
            $stmt = $conn->prepare("DELETE FROM buttons WHERE id_button=?;");
           $stmt->bindValue(1, $buttonId);
            $stmt->execute();
        }catch (PDOException $e) {
            echo "Connection failed: 2 " . $e->getMessage();
        }
    }
    
    // Function to handle button click and update clicks count in the database
    function handleClick($conn, $buttonId) {
        $stmt = $conn->prepare("UPDATE buttons SET clicks = clicks + 1 WHERE id_button = ?");
        $stmt->bindValue(1, $buttonId);
        $stmt->execute();
    }
    
    //groups fuctions:
    
    function insertGroupData($conn, $name, $color, $is_active) {
        $stmt = $conn->prepare("INSERT INTO groups (name, color, is_active) VALUES (?, ?, ?)");
        $stmt->bindValue(1, $name);
        $stmt->bindValue(2, $color);
        $stmt->bindValue(3, $is_active);
        $stmt->execute();
    }
    
    // Function to update data in the groups table
    function updateGroupData($conn, $name, $color, $is_active, $id_group) {
        $stmt = $conn->prepare("UPDATE groups SET name=?, color=?, is_active=? WHERE id_group=?;");
        $stmt->bindValue(1, $name);
        $stmt->bindValue(2, $color);
        $stmt->bindValue(3, $is_active);
        $stmt->bindValue(4, $id_group);
        $stmt->execute();
    }
    
     // Function to delete data from the groups table
    function deleteGroupData($conn, $groupId) {
        $stmt = $conn->prepare("DELETE FROM groups WHERE id_group=?;");
        $stmt->bindValue(1, $groupId);
        $stmt->execute();
    }
    
    //pages fuctions:
    
    function insertPageData($conn, $pagename, $pagegroup, $page_icon, $url_slug, $pagecontent, $is_active) {
        $stmt = $conn->prepare("INSERT INTO pages (pagename, pagegroup, page_icon, url_slug, pagecontent, is_active) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bindValue(1, $pagename);
        $stmt->bindValue(2, $pagegroup);
        $stmt->bindValue(3, $page_icon);
        $stmt->bindValue(4, $url_slug);
        $stmt->bindValue(5, $pagecontent);
        $stmt->bindValue(6, $is_active);
        $stmt->execute();
    }
    
    // Function to update data in the pages table
    function updatePageData($conn, $pagename, $pagegroup, $page_icon, $url, $pagecontent, $is_active, $id_page) {
        $stmt = $conn->prepare("UPDATE pages SET pagename=?, pagegroup=?, page_icon=?, url_slug=?, pagecontent=?, is_active=? WHERE id_page=?;");
        $stmt->bindValue(1, $pagename);
        $stmt->bindValue(2, $pagegroup);
        $stmt->bindValue(3, $page_icon);
        $stmt->bindValue(4, $url);
        $stmt->bindValue(5, $pagecontent);
        $stmt->bindValue(6, $is_active);
        $stmt->bindValue(7, $id_page);
        $stmt->execute();
    }
    
     // Function to delete data from the pages table
    function deletePageData($conn, $pageId) {
        $stmt = $conn->prepare("DELETE FROM pages WHERE id_page=?;");
        $stmt->bindValue(1, $pageId);
        $stmt->execute();
    }
    
    //users fuctions:
    
    // Function to insert data into the users table
    function insertUserData($conn, $param_username, $param_password ) {
        $stmt = $conn->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
        $stmt->bindValue(1, $param_username);
        $stmt->bindValue(2, $param_password);       
        $stmt->execute();
    }
    
    // Function to update data in the users table
    function updateUserData($conn, $username, $password, $id_user) {
        $stmt = $conn->prepare("UPDATE users SET username=?, password=? WHERE id_user=?;");
        $stmt->bindValue(1, $username);
        $stmt->bindValue(2, $password);        
        $stmt->bindValue(3, $id_user);
        $stmt->execute();
    }
    
    // Function to delete data from the users table
    function deleteUserData($conn, $id_user) {
        $stmt = $conn->prepare("DELETE FROM users WHERE id_user=?;");
        $stmt->bindValue(1, $id_user);
        $stmt->execute();
    }
    
    // Call the functions to create and insert data into the tables
    createTables($database);
    // insertButtonData($database);
    // insertGroupsData($database);
    // insertUsersData($database);
   
    
    // Close the database connection
    $database->close();
    
?>
