<?php

    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: index.php");
        exit;
    }

?>

<html>
 <head>
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
      
        <script type="text/javascript" language="javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    	<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    	<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
    	
    	<script type="text/javascript" language="javascript" src="js/hexa-to-rgb-color.js"></script>
      
        <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/js/bootstrap.min.js"></script>
        <script src="https://cpwebassets.codepen.io/assets/common/stopExecutionOnTimeout-2c7831bb44f98c1391d6a4ffda0e1fd302503391ca806e7fcc7b9b87197aec26.js"></script>
        
  <style>
   body {
        margin:0;
        padding:0;
        background-color:#f1f1f1;
    }
    .box {
        /* width:1280px; */
        width: 95%;
        max-width: 1920px !important;
        padding:20px;
        background-color:#fff;
        border:1px solid #ccc;
        border-radius:5px;
        margin-top:25px;
   }
  </style>
 </head>
 <body>
  <div class="container box">
   <h1 align="center"></h1>
   <br />
   <div class="table-responsive">
    <br />
    <div align="right">
     <button type="button" id="add_group" data-toggle="modal" data-target="#groupModal" class="btn btn-info btn-lg">Adicionar Grupo</button>     
    </div>
    <br /><br />

    <table id="group_data" class="table table-bordered table-striped">
     <thead>
      <tr>
       <th width="20%">Grupo</th>
       <th width="45%">Cor</th>
       <th width="10%">Status</th>
       <th width="10%">Editar</th>
       <th width="10%">Remover</th>
      </tr>
     </thead>
    </table>
    
   </div>
  </div>
 </body>
</html>

<div id="groupModal" class="modal fade">
 <div class="modal-dialog">
  <form method="post" id="group_form" enctype="multipart/form-data">

   <div class="modal-content">

    <div class="modal-header">
     <button type="button" class="close" data-dismiss="modal">&times;</button>
     <h4 class="modal-title">Adicionar Grupo</h4>
    </div>

    <div class="modal-body">
        <label>Grupo</label>
        <input type="text" name="group" id="group" class="form-control" />
        <br />

        <label for="favcolor">Selecionar cor:</label>
        <input type="color" id="groupcolor" name="groupcolor" value="#ff0000">
        
        <br><br> 
        
        <input type="radio" id="enable" name="is_active" value="1">
        <label for="enable">habilitado</label>
  
        <input type="radio" id="disable" name="is_active" value="0">
        <label for="disable">desabilitado</label><br>
        
        <br>      

    </div>

    <div class="modal-footer">
     <input type="hidden" name="id_group" id="id_group" />
     <input type="hidden" name="operation" id="group_operation" />
     <input type="submit" name="action" id="action" class="btn btn-success" value="Add" />
     <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
    </div>

   </div>
  </form>
 </div>
</div>

<script type="text/javascript" language="javascript" >
$(document).ready(function(){ 

 $('#add_group').click(function(){
  $('#group_form')[0].reset();
  $('.modal-title').text("Adicionar Grupo");
  $('#action').val("Adicionar");
  $('#group_operation').val("Add");  
 });

 $(document).on('submit', '#group_form', function(event){
  event.preventDefault();
  var group = $('#group').val();
  var groupcolor = $('#groupcolor').val();
  
  
  if(group != '' && groupcolor != '')
  {
   $.ajax({
    url:"groupInsert.php",
    method:'POST',
    data:new FormData(this),
    contentType:false,
    processData:false,
    success:function(data)
    {
     alert(data);
     $('#group_form')[0].reset();
     $('#groupModal').modal('hide');
     dataTable.ajax.reload();
    }
   });
  }
  else
  {
   alert("Ambos os campos são necessários");
  }
 });


 var dataTable = $('#group_data').DataTable({
  "processing":true,
  "serverSide":true,
  "order":[],
  "ajax":{
   url:"groupFetch.php",
   type:"POST"
  },
  "columnDefs":[
   {
    "targets": [2, 3, 4],
    "orderable":false,
   },
  ],
  "columns": [ 
  ]
 });

 
 $(document).on('click', '.update', function(){
  var id_group = $(this).attr("id_group");
  $.ajax({
   url:"groupFetch_single.php",
   method:"POST",
   data:{id_group:id_group},
   dataType:"json",
   success:function(data)
   {
    $('#groupModal').modal('show');
    $('#group').val(data.name);
    $('#groupcolor').val(data.color);
    
    // Check the radio button based on the value of is_active
    if (data.is_active == 1) {
        $('#enable').prop('checked', true);
    } else {
        $('#disable').prop('checked', true);
    }
    
    
    $('.modal-title').text("Editar Botão");
    $('#id_group').val(id_group);    
    $('#action').val("Edit");
    $('#group_operation').val("Edit");
   }
  })
 });

 
 $(document).on('click', '.delete', function(){
  var id_group = $(this).attr("id_group");
  if(confirm("Are you sure you want to delete this?"))
  {
   $.ajax({
    url:"groupDelete.php",
    method:"POST",
    data:{id_group:id_group},
    success:function(data)
    {
     alert(data);
     dataTable.ajax.reload();
    }
   });
  }
  else
  {
   return false; 
  }
 });
 
 
});
</script>