<?php

    // require ('dbconnection.php');
    
    // require ('database/digital.php');
    
    // // Call the function to delete data from the pages table
    // deletePageData($conn, $id_page);
    
    // if (isset($_POST["id_page"])) {
    //     $result = deletePageData(
    //         $conn,
    //         $_POST["id_page"]
    //     );
    //     if ($result === NULL) {
    //         echo 'Página Apagada!';
    //     }
    // }
    
    
    
require('dbconnection.php');
require('database/digital.php');

// Function to delete a button and its associated image
function deleteButton($conn, $id_button)
{
    // Get the image name associated with the button
    $image = get_image_name($conn, $id_button);

    // Delete the image file if it exists
    if ($image != '') {
        unlink("../images/uploads/" . $image);
    }

    // Call the function to delete data from the buttons table
    deleteButtonData($conn, $id_button);
}

// Function to get the image name associated with a button
function get_image_name($conn, $id_button)
{
    try {
        $statement = $conn->prepare("SELECT icon FROM buttons WHERE id_button = :id_button");
        $statement->bindParam(':id_button', $id_button, PDO::PARAM_INT);
        $statement->execute();
        $result = $statement->fetchAll();

        foreach ($result as $row) {
            return $row["icon"];
        }
    } catch (PDOException $e) {
        echo "get_image_name (falha na conexao): " . $e->getMessage();
    }
}

if (isset($_POST["id_page"])) {
    // Retrieve the id_button associated with the page
    $statement = $conn->prepare("SELECT page_icon FROM pages WHERE id_page = :id_page");
    $statement->bindParam(':id_page', $_POST["id_page"], PDO::PARAM_INT);
    $statement->execute();
    $result = $statement->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        $id_button = $result['page_icon'];

        // Delete the button and its associated image
        deleteButton($conn, $id_button);
    }

    // Call the function to delete data from the pages table
    deletePageData($conn, $_POST["id_page"]);

    // Call the function to delete the page
    $result = deletePageData($conn, $_POST["id_page"]);

    if ($result === NULL) {
        echo 'Página Apagada!';
    }
}

if (isset($_POST["id_button"])) {
    // Delete the button and its associated image
    deleteButton($conn, $_POST["id_button"]);

    echo 'Botao apagado com sucesso!';
}

// Close the database connection
$database->close();
    
    
    
    
?>
