<?php

require ('dbconnection.php');
require ('database/digital.php');

//include('function.php');

function get_total_all_records($conn)
{
    $statement = $conn->prepare("SELECT * FROM pages");
    $statement->execute();
    $result = $statement->fetchAll();
    return count($result);
}

try {
    $query = '';
    $output = array();
    $query .= "SELECT pages.*, pages.pagename FROM pages LEFT JOIN groups ON pages.pagegroup = groups.id_group LEFT JOIN buttons ON pages.page_icon = buttons.id_button ";

    if (isset($_POST["search"]["value"])) {
        $query .= 'WHERE pagename LIKE "%' . $_POST["search"]["value"] . '%" ';
        $query .= 'OR url_slug LIKE "%' . $_POST["search"]["value"] . '%" ';
        $query .= 'OR pagegroup LIKE "%' . $_POST["search"]["value"] . '%" ';
    }

    if (isset($_POST["order"])) {
        $query .= 'ORDER BY ' . $_POST['order']['0']['column'] . ' ' . $_POST['order']['0']['dir'] . ' ';
    } else {
        $query .= 'ORDER BY id_page DESC ';
    }

    if ($_POST["length"] != -1) {
        $query .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
    }

    $statement = $conn->prepare($query);
    $statement->execute();
    $result = $statement->fetchAll();
    $data = array();
    $filtered_rows = count($result);

    foreach ($result as $row) {
        $sub_array = array();
        $sub_array[] = $row["id_page"];
        $sub_array[] = $row["pagename"];
        $sub_array[] = $row["url_slug"];
        $sub_array[] = $row["pagegroup"];
        $sub_array[] = ($row["is_active"] == 1) ? '<span class="btn btn-success" disabled>Ativo</span>' : '<span class="btn btn-danger btn-xs" disabled>Inativo</span>';
        $sub_array[] = '<button type="button" name="update" id_page="' . $row["id_page"] . '" class="btn btn-warning btn-xs update">Editar</button>';
        $sub_array[] = '<button type="button" name="delete" id_page="' . $row["id_page"] . '" class="btn btn-danger btn-xs delete">Remover</button>';
        $data[] = $sub_array;
    }

    $output = array(
        "draw" => intval($_POST["draw"]),
        "recordsTotal" => get_total_all_records($conn),
        "recordsFiltered" => $filtered_rows,
        "data" => $data
    );

    echo json_encode($output);

    // Close the database connection (optional, as PDO closes automatically when the script ends)
    //$conn = null;
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}
?>
