<?php
    
    require ('dbconnection.php');
    
    require ('database/digital.php');
    
    $base_url = "https://digital.mogiguacu.sp.gov.br/";
    
    
    // Function to upload image
    function upload_image(){
        if(isset($_FILES["icon_image"])){
          $extension = explode('.', $_FILES['icon_image']['name']);
          $new_name = rand() . '.' . $extension[1];
          $destination = '../images/uploads/' . $new_name;
          move_uploaded_file($_FILES['icon_image']['tmp_name'], $destination);
          return $new_name;
        }
    }
    
    
    try {
    
        if (isset($_POST["operation"])) {
            if ($_POST["operation"] == "Add") {
    
                $image = '';
                
                if ($_FILES["icon_image"]["name"] != '') {
                    // Call the upload_image function here to handle image upload
                    $image = upload_image();
                }
                
                $posturl = $_POST["url"];
                
                $url = $base_url . $posturl;
                
                // Insert button data and get the inserted ID
                $inserted_button_id = insertButtonData(
                    $conn,
                    $image,
                    $_POST["label"],
                    $_POST["tags"],
                    $_POST["shorttext"],
                    $url,
                    $_POST["bgcolor"],
                    $_POST["iconcolor"],
                    $_POST["categoria"],
                    isset($_POST["is_active"]) ? $_POST["is_active"] : 1
                );
                 
                if ($inserted_button_id !== NULL) {
                    // Use $inserted_button_id wherever you need it, for example:
                    $icon = $inserted_button_id;
                    
                    // Proceed to insert page data or other operations
                    $result = insertPageData(
                        $conn,
                        $_POST["page"],
                        $_POST["group"],
                        $icon, // Assuming $icon is now the ID of the inserted button
                        $posturl,
                        $_POST["content"],
                        isset($_POST["is_active"]) ? $_POST["is_active"] : 1 
                    );
                    if ($result !== NULL) {
                        echo 'Data Inserted';
                    }
                } else {
                    echo 'Failed to insert button data';
                }
            }

    
            if ($_POST["operation"] == "Edit") {
                
                
                $image = '';
                
                if ($_FILES["icon_image"]["name"] != '') {
                    // Call the upload_image function here to handle image upload
                    $image = upload_image(); 
                } else {
                    $image = $_POST["hidden_icon"];
                }
                
                $posturl = $_POST["url"];
                
                $url = $base_url . $posturl;
    
                // Update button data first
                $button_update_result = updateButtonData(
                    $conn,
                    $image,
                    $_POST["label"],
                    $_POST["tags"],
                    $_POST["shorttext"],
                    $url,
                    $_POST["bgcolor"],
                    $_POST["iconcolor"],
                    $_POST["categoria"],
                    $is_active = isset($_POST["is_active"]) ? $_POST["is_active"] : 1,
                    $_POST["id_button"]
                );
    
                if ($button_update_result === NULL) {
                    // Proceed to update page data
                    $page_update_result = updatePageData(
                        $conn,
                        $_POST["page"],
                        $_POST["group"],
                        $_POST["id_button"],
                        $posturl,
                        $_POST["content"],
                        isset($_POST["is_active"]) ? $_POST["is_active"] : 1,
                        $_POST["id_page"]
                    );
                    if ($page_update_result === NULL) {
                        echo 'Data Updated';
                    } else {
                        echo 'Failed to update page data';
                    }
                } else {
                    echo 'Failed to update button data';
                }
            }
        }
    } catch (PDOException $e) {
        die("Connection failed: " . $e->getMessage());
    }
?>
