<?php

    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: index.php");
        exit;
    }

?>

<!DOCTYPE html>
<html>
    <head>
      <title>Portal - Guaçu Digital - Admin</title>
      
      
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

      
        <script type="text/javascript" language="javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    	<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    	<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
      
        <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/js/bootstrap.min.js"></script>
        <script src="https://cpwebassets.codepen.io/assets/common/stopExecutionOnTimeout-2c7831bb44f98c1391d6a4ffda0e1fd302503391ca806e7fcc7b9b87197aec26.js"></script>
        
        
        <script src="https://cdn.tiny.cloud/1/h2widbkfye9rpy8sk19imrg4hqf6k66obs2impe1ve32ioqw/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>
        <script>
            tinymce.init({
                selector: "textarea#content",
                language: 'pt_PT',
                plugins: [
                    "advlist", "anchor", "autolink", "autoresize", "autosave",
                    "charmap", "code", "codesample", "directionality", "emoticons",
                    "fullscreen", "help", "image", "importcss", "insertdatetime",
                    "link", "linkchecker", "lists", "media", "nonbreaking", "pagebreak",
                    "preview", "quickbars", "save", "searchreplace", "table",
                    "tinydrive", "visualblocks", "visualchars", "wordcount"
                ],
                height: 450,
                force_br_newlines: false,
                forced_root_block: 'p',
                file_picker_types: 'file, image',
                file_picker_callback: function(callback, value, meta) {
        
                        $("#fileInput").click();  // open the chooser       
        
                        //var tkn=getToken();       // set any other fields to upload with your file
                        var tkn = new Date();
                        $("#pdfToken").val(tkn);                        
        
                        $("#fileInput").on("change",function(){
        
                            var dataString=new FormData($("#PDFform")[0]);
        
                              $.ajax({
                                    type: "POST",
                                    url: "uploads.php",
                                    enctype: "multipart/form-data",
                                    data: dataString,
                                    processData: false,
                                    contentType: false,                                             
                                    dataType: "json",
                                    error: error,
                                    success: function(json) {
        
        
                                        // reset the form or it won't work a 2nd time
                                        $("#PDFuform").trigger("reset");
        
                                        // if your script returns JSON you can process it here
                                        // mine looks like {"location":"data/editorUploads/test.pdf","alt":"test.pdf"}
                                        callback(json.location, {alt: json.alt, text: json.alt });
        
                                    }
                              });                   
        
                        });                         
        
                },                          
                    automatic_uploads: true,
                    setup: (editor) => {
                      editor.on("NodeChange", (e) => {
                        if (e.element.tagName === "IMG") { 
                            var texto = editor.getContent();
                            const regex = /<img src="(\.\.\/uploadfiles\/)(.*?)(\.pdf)" alt="(.*?)">/gm;
                            const resultado = texto.replace(regex, '<a href="$1$2$3" target="_blank">$2$3</a>');
                            editor.setContent(resultado);
                }
                      })                }
            });
            
            function error(e){
                console.log(e.responseText);
            }
            
            // When an image is inserted into the editor after image upload...
            tinymce.on('change', function (e) {
                console.log(e.element)
                if (e.element.tagName === "IMG") { 
                    console.log(e.element)
                    return; 
                }
                return;
            });
                        
        </script>
      
      
        <style>
            body {
                margin:0;
                padding:0;
                background-color:#f1f1f1;
            }
            .box {
                /* width:1280px; */
                width: 95%;
                max-width: 1920px !important;
                padding:20px;
                background-color:#fff;
                border:1px solid #ccc;
                border-radius:5px;
                margin-top:25px;
            }
            .pixel {
                display: inline-block;
                background-color: #000;
                width: 50px;
                height: 50px;
            }
            .filterDetail {
                font-family: "Consolas", "Menlo", "Ubuntu Mono", monospace;
            }
            .iconpreview {
                max-width: 60px;
                max-height: 60px;
                filter: invert(100%) sepia(0%) saturate(7499%) hue-rotate(65deg) brightness(100%) contrast(104%);
                height: 100%;
            }
            .modal-dialog {
                max-width: 900px;
                margin: 0 auto;
                padding: 20px;
                background-color: #fff;
                border-radius: 10px;
                box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            }
            .modal-title {
                color: #333;
             }
            .modal-body {
                margin-bottom: 10px;
            }
            label {
                font-weight: bold;
            }
            .form-control {
                width: 100%;
                /*padding: 8px;*/
                border: 1px solid #ccc;
                border-radius: 4px;
                box-sizing: border-box;
                margin-bottom: 10px;
            }
            textarea {
                width: 100%;
                padding: 8px;
                border: 1px solid #ccc;
                border-radius: 4px;
                box-sizing: border-box;
            }
            select {
                width: 100%;
                padding: 8px;
                border: 1px solid #ccc;
                border-radius: 4px;
            }
            button {
                padding: 8px 15px;
                background-color: #19837f;
                color: #fff;
                border: none;
                border-radius: 4px;
                cursor: pointer;
            }
            button:hover {
                background-color: #156d6b;
            }
              
            .pickcolor{
            	align-items: center;
            	text-align: center;
            }
            .container {
                max-width: 1280px;
            }
            
            .hideMe{
                display:none;
            }
        </style>
    </head>
    <body>
      <div class="container box">
       <h1 align="center"></h1>
       <br />
       <div class="table-responsive">
        <br />
        <div align="right">     
         <button type="button" id="add_page" data-toggle="modal" data-target="#pageModal" class="btn btn-info btn-lg">Adicionar página</button>
        </div>
        <br /><br />
    
        <table id="button_data" class="table table-striped table-bordered" style="width:100%">
         <thead>
          <tr>
            <th>ID</th>
            <th>Página</th>
            <th>Grupo</th>           
            <th>Status</th>
            <th>Editar</th>
             <th>Remover</th>
          </tr>
         </thead>
        </table>
        
       </div>
      </div>
    </body>
    <form id="PDFform" 
      class="hideMe"
      method="post"
      enctype="multipart/form-data" 
      <input id="pdfToken" type="hidden" name="dzToken">
      <input id="fileInput" name="pdf" type="file">
    </form>
</html>


<div id="pageModal" class="modal fade">
	<div class="modal-dialog">
		<form method="post" id="page_form" enctype="multipart/form-data">
			<div class="modal-content">
				<div class="modal-header">					
					<h4 class="modal-title">Adicionar Página</h4>
				</div>
				<div class="modal-body">
				
					<label>Nome da página:</label>
					<input type="text" name="page" id="page" class="form-control">
					<br>
					
					<label>Grupo da página:</label>
					<select name="group" id="group">

						<?php
                            // Replace 'your_database.db' with the path to your SQLite database file
                            $dbname = 'database/digital.db';
                            
                            try {
                                // Create a new SQLite PDO connection
                                $conn = new PDO("sqlite:$dbname");
                                $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                            
                                // Consulta para obter os grupos da tabela "grupo"
                                $sqlGrupos = "SELECT * FROM groups ORDER BY name ASC";
                                $resultGrupos = $conn->query($sqlGrupos);
                                $groupsArray = $resultGrupos->fetchAll(PDO::FETCH_ASSOC);
                                
                                // Laço para imprimir os grupos e as imagens relacionadas a eles
                                if (count($groupsArray) > 0) {
                                    foreach ($groupsArray as $rowButton) {
                                        echo '<option value="' . $rowButton["id_group"] . '" class="form-control">' . $rowButton["name"] . '</option>';
                                    }
                                } else {
                                    echo "Nenhum grupo encontrado na tabela.";
                                }

                            
                                // Close the database connection (optional, as PDO closes automatically when the script ends)
                                $conn = null;
                            } catch (PDOException $e) {
                                die("Connection failed: " . $e->getMessage());
                            }
                        ?>          
						
					</select>
					
					<br>
					<br>	
					
					<label>Botão da página:</label>
					<select name="icon" id="icon">

						<?php
                            // Replace 'your_database.db' with the path to your SQLite database file
                            $dbname = 'database/digital.db';
                            
                            try {
                                // Create a new SQLite PDO connection
                                $conn = new PDO("sqlite:$dbname");
                                $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                            
                                // Consulta para obter os botoes da tabela "buttons"
                                $sqlButtons = "SELECT * FROM buttons ORDER BY label ASC";
                                $resultButtons = $conn->query($sqlButtons);
                                $buttonsArray = $resultButtons->fetchAll(PDO::FETCH_ASSOC);
                                
                                // Laço para imprimir os grupos e as imagens relacionadas a eles
                                if (count($buttonsArray) > 0) {
                                    foreach ($buttonsArray as $rowButton) {
                                        echo '<option value="' . $rowButton["id_button"] . '" class="form-control">' . $rowButton["label"] . '</option>';
                                    }
                                } else {
                                    echo "Nenhum botão encontrado na tabela.";
                                }

                            
                                // Close the database connection (optional, as PDO closes automatically when the script ends)
                                $conn = null;
                            } catch (PDOException $e) {
                                die("Connection failed: " . $e->getMessage());
                            }
                        ?>          
						
					</select>
					
					<br><br>

					<label>Conteudo da página:</label>
					<textarea id="content" name="content">Insira o conteúdo da página!</textarea>
					
					<br><br>
					
					<input type="radio" id="enable" name="is_active" value="1">
                    <label for="enable">habilitada</label>
              
                    <input type="radio" id="disable" name="is_active" value="0">
                    <label for="disable">desabilitada</label><br>				
									  
									
				</div>
            	<div class="modal-footer">
                 <input type="hidden" name="id_page" id="id_page" />
                 <input type="hidden" name="operation" id="page_operation" />
                 <input type="submit" name="action" id="action" class="btn btn-success" value="Add" />
                 <button type="button" class="btn btn-danger" data-dismiss="modal">Fechar</button>
                </div>
			</div>
		</form>
	</div>
</div>

<script type="text/javascript" language="javascript" >
$(document).ready(function(){

 $('#add_page').click(function(){
  $('#page_form')[0].reset();
  $('.modal-title').text("Adicionar Página");
  $('#action').val("Adicionar");
  $('#page_operation').val("Add");  
 });

 $(document).on('submit', '#page_form', function(event){
  event.preventDefault();
  
    var page = $('#page').val();
    var group = $('#group').val();
    var icon = $('#icon').val();
    var content = $('#content').val();

    var emptyFields = [];
    
    if (page == '') {
        emptyFields.push('Page');
    }
    
    if (group == '') {
        emptyFields.push('Group');
    }
    
    if (icon == '') {
        emptyFields.push('Icon');
    }
    
    if (content == '') {
        emptyFields.push('Content');
    }

    if (emptyFields.length == 0) {
        $.ajax({
            url: "pageInsert.php",
            method: 'POST',
            data: new FormData(this),
            contentType: false,
            processData: false,
            success: function(data) {
                alert(data);
                $('#page_form')[0].reset();
                $('#pageModal').modal('hide');
                dataTable.ajax.reload();
            }
        });
    } else {
        alert("Os seguintes campos são obrigatórios: " + emptyFields.join(', '));
    }
 });

 var dataTable = $('#button_data').DataTable({
  "processing":true,
  "serverSide":true,
  "order":[],
  "ajax":{
   url:"pageFetch.php",
   type:"POST"
  },
  "columnDefs":[
   {
    "targets":[4, 5],
    "orderable":false,
   },
  ],
  "columns": []
 });

 
 $(document).on('click', '.update', function(){
     
  var id_page = $(this).attr("id_page");
  $.ajax({
   url:"pageFetch_single.php",
   method:"POST",
   data:{id_page:id_page},
   dataType:"json",
   success:function(data)
   {
    $('#pageModal').modal('show');
    $('.modal-title').text("Editar Página");
    
    
    $('#idpage').val(data.id_page);
    $('#page').val(data.pagename);
    $('#group').val(data.pagegroup);
    tinyMCE.activeEditor.setContent(data.pagecontent);
    $('#icon').val(data.page_icon);
    $('#id_page').val(id_page);
    
    // Check the radio button based on the value of is_active
    if (data.is_active == 1) {
        $('#enable').prop('checked', true);
    } else {
        $('#disable').prop('checked', true);
    }
    
    $('#action').val("Edit");
    $('#page_operation').val("Edit");
    
   }
  })
 });
 
 $(document).on('click', '.delete', function(){
  var id_page = $(this).attr("id_page");
  if(confirm("Are you sure you want to delete this?"))
  {
   $.ajax({
    url:"pageDelete.php",
    method:"POST",
    data:{id_page:id_page},
    success:function(data)
    {
     alert(data);
     dataTable.ajax.reload();
    },
    error: function (data) {
        alert(JSON.stringify(data));
    }
   });
  }
  else
  {
   return false; 
  }
 });
 
 
});
</script>