<?php

// Base URL
$baseurl = "https://digital.mogiguacu.sp.gov.br/";

// Caminho para o arquivo do banco de dados SQLite
$dbname = '../admin/database/digital.db';

// Crie uma nova conexão SQLite PDO
$conn = new PDO("sqlite:$dbname");
$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

class Group {
    private $conn;
    private $table_name = "groups";

    public function __construct($db) {
        $this->conn = $db;
    }

    public function totalGroup() {		
        $sqlQuery = "SELECT COUNT(*) as total FROM " . $this->table_name;			
        $stmt = $this->conn->prepare($sqlQuery);			
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result['total'];	
    }	
}

class Button {
    private $conn;
    private $table_name = "buttons";

    public function __construct($db) {
        $this->conn = $db;
    }

    public function totalButton() {		
        $sqlQuery = "SELECT COUNT(*) as total FROM " . $this->table_name;			
        $stmt = $this->conn->prepare($sqlQuery);			
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result['total'];	
    }	
}

class Page {
    private $conn;
    private $table_name = "pages";

    public function __construct($db) {
        $this->conn = $db;
    }

    public function totalPage() {		
        $sqlQuery = "SELECT COUNT(*) as total FROM " . $this->table_name;			
        $stmt = $this->conn->prepare($sqlQuery);			
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result['total'];	
    }	
}

class User {
    private $conn;
    private $table_name = "users";

    public function __construct($db) {
        $this->conn = $db;
    }

    public function totalUser() {		
        $sqlQuery = "SELECT COUNT(*) as total FROM " . $this->table_name;			
        $stmt = $this->conn->prepare($sqlQuery);			
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result['total'];	
    }	
}

$group = new Group($conn);
$button = new Button($conn);
$page = new Page($conn);
$user = new User($conn);

?>

<!DOCTYPE html>
<html lang="pt-BR">
  
<head>
    
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <meta http-equiv="Content-Language" content="pt-BR">
    <meta name="description" content="Serviços - Prefeitura Municipal de Mogi Guaçu">
    <meta name="author" content="Secretarria de Tecnologia e Inovação - Departamento de Tecnologia">
    <meta name="language" content="pt-BR">
    <meta name="classification" content="E-GOV">

    <link rel="shortcut icon" href="https://mogiguacu.sp.gov.br/images/favicon.ico" />

    <link href="../css/stilo.css" rel="stylesheet"/>
    <link rel="stylesheet" href="../css/lgpd.css">
    <link rel="stylesheet" href="../css/tabler-icons.min.css">
    
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
    </script><script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js"></script>
    <link href="css/style.css" rel="stylesheet" type="text/css" >  
    
    <script src="../js/jquery-3.2.1.min.js"></script>    
    <script src="../js/pmmg.js"></script>  

    <title>Serviços - Prefeitura Municipal de Mogi Guaçu</title>
    <meta name="keywords" content="Prefeitura Municipal de Mogi Guaçu, Guaçu Digital" />
    
    <style>
      
        .topnav{
            min-height:38px;
        }
        .conteudo-geral {
            max-width: 1900px;
            margin: 0 auto;
            padding-top: 10px;
        }
        .panel-title {
            color: white;
        }
        .rodape{
            position: fixed;
            left: 0;
            bottom: 0;
            width: 100%;
        }
        .list-group-item.active{
            background-color: var(--main_blue)!important;
        }
        .panel-default>.panel-heading {
            color: #333;
            background-color: var(--main_blue)!important;
            border-color: #ddd;
        }
        
    </style>
    
</head>
  <body>
      
      
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC INICIO -->
    <header class="cabecalho-bg">
        <div class="cabecalho">
            <div class="logo">
              <div class="logo-img">
                <h1>
                  <a href="https://digital.mogiguacu.sp.gov.br" target="_top" id="Logotipo" onclick="trackEvent(this)">
                    <img src="../images/logoguacu.png" alt="Prefeitura Municipal de Mogi Guaçu" width="250" height="72" />
                  </a>
                </h1>
              </div>
            </div>
        </div>
        <div class="menu">
            <div class="topnav" id="myTopnav">
                        
            </div>
        </div>
    </header>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC FIM -->
    
    
    <section class="conteudo-geral">
        
        
        <section id="main">
          <div class="container">
            <div class="row">
        	
        	<div class="col-md-3">
            	<div class="list-group">
            		<a href="dashboard.php" class="list-group-item active main-color-bg"><span class="glyphicon glyphicon-cog" aria-hidden="true"></span>Dashboard <span class="badge"><?php echo $group->totalGroup()+$button->totalButton()+$page->totalPage()+$user->totalUSer(); ?></span></a>		
            		<a href="posts.php" class="list-group-item"><span class="glyphicon glyphicon-list-alt" aria-hidden="true"></span>Grupos<span class="badge"><?php echo $group->totalGroup(); ?></span></a>
            		<a href="categories.php" class="list-group-item"><span class="glyphicon glyphicon-bookmark" aria-hidden="true"></span>Botões<span class="badge"><?php echo $button->totalButton(); ?></span></a>
            		<a href="users.php" class="list-group-item"><span class="glyphicon glyphicon-file" aria-hidden="true"></span>Páginas<span class="badge"><?php echo $page->totalPage(); ?></span></a>
            		<a href="users.php" class="list-group-item"><span class="glyphicon glyphicon-user" aria-hidden="true"></span>Usuários<span class="badge"><?php echo $user->totalUSer(); ?></span></a>
            	</div>
            </div>
            <div class="col-md-9">
                <div class="panel panel-default">
                    <div class="panel-heading" style="background-color:  #095f59;">
                        <h3 class="panel-title">Website Overview</h3>
                    </div>
                    <div class="panel-body">
                        <div class="col-md-3">
                         <div class="well dash-box">
                           <h2><span class="glyphicon glyphicon-list-alt" aria-hidden="true"></span><?php echo $group->totalGroup(); ?></h2>
                           <h4>Grupos</h4>
                         </div>
                        </div>
                        <div class="col-md-3">
                         <div class="well dash-box">
                           <h2><span class="glyphicon glyphicon-bookmark" aria-hidden="true"></span><?php echo $button->totalButton(); ?></h2>
                           <h4>Botões</h4>
                         </div>
                       </div>
                       <div class="col-md-3">
                         <div class="well dash-box">
                           <h2><span class="glyphicon glyphicon-file" aria-hidden="true"></span><?php echo $page->totalPage(); ?></h2>
                           <h4>Páginas</h4>
                         </div>
                       </div>
                       <div class="col-md-3">
                         <div class="well dash-box">
                           <h2><span class="glyphicon glyphicon-user" aria-hidden="true"></span><?php echo $user->totalUSer(); ?></h2>
                           <h4>Usuários</h4>
                         </div>
                       </div>   
                    </div>
                </div>
              </div>
            </div>
          </div>
        </section>
        
        
      
    </section>
    
    
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE INICIO -->
    <footer class="rodape">
      <div class="rodape-container">
        <div class="rodape-texto">
          <div class="end-rodape-1">Rua Henrique Coppi, nº 200 Centro <br />CEP: 13820-641 | +55 (19) 3851-7000 </div>
          <div class="end-rodape-2">Rua Henrique Coppi, nº 200 <br /> +55 (19) 3851-7000 </div>
        </div>
        <div class="rodape-brasao">
          <div class="rodape_brasao_img">
            <img src="../images/guacuDigital.svg" alt="Guaçu Digital" width="127" height="50" />
          </div>
        </div>
        <div class="rodape-mapadosite">
                Secretaria de Tecnologia e Inovação
            </br>
                Departamento de Tecnologia
            </br>
                2024
        </div>
      </div>
    </footer>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE FIM -->
    
    
</body>    
</html>