<?php
// Verifica se pelo menos um dos parâmetros foi fornecido
if(isset($_GET['nome_proprietario']) || isset($_GET['inscricao']) || isset($_GET['logradouro_local'])) {
    // Dados de autenticação
    $username = 'PkB-3oILBF9DicH3cDyH6w..';
    $password = 'Go6OKC6Ailx8o9erCGjShg..';

    // URL do endpoint para obter o token de acesso
    $token_url = 'https://mogiguacu.intertecsolucoes.com.br/ords/mguacu/ws/oauth/token?grant_type=client_credentials';

    // Dados para a autenticação Basic
    $auth_token = base64_encode("$username:$password");

    // Configuração das opções da solicitação para obter o token
    $token_options = array(
        CURLOPT_URL => $token_url,
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
            "Authorization: Basic $auth_token"
        )
    );

    // Inicializa o cURL para obter o token
    $token_ch = curl_init();
    curl_setopt_array($token_ch, $token_options);

    // Executa a solicitação para obter o token
    $token_response = curl_exec($token_ch);

    // Verifica por erros
    if(curl_errno($token_ch)){
        echo 'Erro ao obter o token: ' . curl_error($token_ch);
        exit;
    }

    // Fecha o manipulador cURL para a solicitação de token
    curl_close($token_ch);

    // Decodifica a resposta do token
    $token_info = json_decode($token_response, true);

    // Verifica se houve um erro ao obter o token
    if (isset($token_info['error'])) {
        echo "Erro ao obter o token: " . $token_info['error_description'];
        exit;
    }

    // Extrai o token de acesso
    $access_token = $token_info['access_token'];

    // Inicializa a string de consulta
    $query = "{";

    // Verifica quais parâmetros foram fornecidos e os adiciona à consulta
    if(isset($_GET['nome_proprietario']) && ($_GET['nome_proprietario'] != '')) {
        $nome_proprietario = urlencode($_GET['nome_proprietario']);
        $query .= "\"nome_proprietario\":{\"\$like\":\"%$nome_proprietario%\"}";
    }

    if(isset($_GET['inscricao']) && ($_GET['inscricao'] != '')) {
        $inscricao = urlencode($_GET['inscricao']);
        // Adiciona uma vírgula se outros parâmetros já foram adicionados
        if(strpos($query, ":") !== false) {
            $query .= ",";
        }
        $query .= "\"inscricao\":{\"\$like\":\"%$inscricao%\"}";
    }

    if(isset($_GET['logradouro_local']) && ($_GET['logradouro_local'] != '')) {
        $logradouro_local = urlencode($_GET['logradouro_local']);
        // Adiciona uma vírgula se outros parâmetros já foram adicionados
        if(strpos($query, ":") !== false) {
            $query .= ",";
        }
        $query .= "\"logradouro_local\":{\"\$like\":\"%$logradouro_local%\"}";
    }

    // Fecha a string de consulta
    $query .= "}";

    // URL do endpoint para fazer a solicitação GET
    $get_url = "https://mogiguacu.intertecsolucoes.com.br/ords/mguacu/ws/vw_lista_imob/?q=$query";

    // Configuração das opções da solicitação GET com o token de acesso
    $get_options = array(
        CURLOPT_URL => $get_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer $access_token"
        )
    );

    // Inicializa o cURL para a solicitação GET
    $get_ch = curl_init();
    curl_setopt_array($get_ch, $get_options);

    // Executa a solicitação GET
    $get_response = curl_exec($get_ch);

    // Verifica por erros
    if(curl_errno($get_ch)){
        echo 'Erro na solicitação GET: ' . curl_error($get_ch);
        exit;
    }

    // Fecha o manipulador cURL para a solicitação GET
    curl_close($get_ch);

    // Decodifica a resposta JSON e a imprime de forma organizada
    $json_response = json_decode($get_response, true);

    // Verifica se há resultados
    if(isset($json_response['items']) && !empty($json_response['items'])) {
        // Imprime a abertura da tabela
        echo '<table border="1">';
        echo '<thead><tr><th>Selecionar</th><th>Inscrição</th><th>Nome do Proprietário</th><th>Logradouro/Local</th><th>Número do Imóvel</th><th>Bairro</th></tr></thead>';
        echo '<tbody>';

        // Itera sobre os itens retornados
        foreach ($json_response['items'] as $item) {
            // Imprime os dados em linhas da tabela
            echo '<tr>';
            echo '<td><input type="radio" name="selected_row" value="'.$item['inscricao'].'"></td>';
            echo '<td>'.$item['inscricao'].'</td>';
            echo '<td>'.$item['nome_proprietario'].'</td>';
            echo '<td>'.$item['logradouro_local'].'</td>';
            echo '<td>'.$item['corr_num_imovel'].'</td>';
            echo '<td>'.$item['corr_nom_bairro'].'</td>';
            echo '<td>'.$item['area_terreno'].'</td>';
            echo '</tr>';
        }

        // Imprime o fechamento da tabela
        echo '</tbody></table>';

        // Adicione aqui qualquer outro controle necessário, como botão de envio de formulário, etc.
    } else {
        echo "Nenhum resultado encontrado para a pesquisa.";
    }
} else {
    // Caso nenhum parâmetro seja fornecido
    echo "Por favor, forneça pelo menos um parâmetro de pesquisa.";
}
?>
