<?php
    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: index.php");
        exit;
    }
?>

<!DOCTYPE html>
<html lang="pt-BR">
  
<head>
    
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <meta http-equiv="Content-Language" content="pt-BR">
    <meta name="description" content="Serviços - Prefeitura Municipal de Mogi Guaçu">
    <meta name="author" content="Secretarria de Tecnologia e Inovação - Departamento de Tecnologia">
    <meta name="language" content="pt-BR">
    <meta name="classification" content="E-GOV">

    <link rel="shortcut icon" href="https://mogiguacu.sp.gov.br/images/favicon.ico" />

    <link href="../css/stilo.css" rel="stylesheet"/>
    <link rel="stylesheet" href="../css/lgpd.css">
    <link rel="stylesheet" href="../css/tabler-icons.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
    
    <script src="../js/jquery-3.2.1.min.js"></script>    
    <script src="../js/pmmg.js"></script>  

    <title>Serviços - Prefeitura Municipal de Mogi Guaçu</title>
    <meta name="keywords" content="Prefeitura Municipal de Mogi Guaçu, Guaçu Digital" />
    
    <style>
      .grupo {
        margin: 0 auto;
        max-width: 960px;
        /* min-height: 80px; */
        display: flex;
        flex-wrap: wrap;
        margin-bottom: 10px;
        }
        #myBtn {
            display: none; /* Começa escondido */
            align-items: center; 
            position: fixed;
            bottom: 5px; /* Alterado para 5px do fundo */
            right: 3px;
            z-index: 99;
            font-size: 16px;
            border: none;
            outline: none;
            background-color: red;
            color: white;
            cursor: pointer;
            padding: 15px;
            border-radius: 4px;
            transition: bottom 0.3s; /* Adicionado para suavizar a transição */
        }
      
        #myBtn:hover {
            background-color: #555;
        }
        .no-results-message {
            width: 100%;
            color: #ff0000; /* Cor do texto */
            font-weight: bold; /* Negrito */
            font-size: 16px; /* Tamanho da fonte */
            text-align: center; /* Alinhamento do texto */
            margin-top: 20px; /* Margem superior */
        }
        
        .topnav {
           min-height: 38px;
        }
        
        .rodape {
            min-width: 100%;
            padding: 10px 0;
            min-height: 70px;
            background-color: var(--main_blue);
            color: #fff;
            font-family: MyriadPro;
            position: fixed;
            bottom: 0;
        }
        
    </style>
    
</head>
  <body>
      
        <button onclick="topFunction()" id="myBtn" title="Go to top">
            <div class="serv_voltar_seta_img">
                <img src="../images/seta_up.svg" alt="Voltar ao topo">
            </div>
            <div class="serv_voltar_texto_link">
                VOLTAR AO TOPO
            </div>
        </button>
      
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC INICIO -->
    <header class="cabecalho-bg">
        <div class="cabecalho">
            <div class="logo">
              <div class="logo-img">
                <h1>
                  <a href="https://digital.mogiguacu.sp.gov.br" target="_top" id="Logotipo" onclick="trackEvent(this)">
                    <img src="../images/logoguacu.png" alt="Prefeitura Municipal de Mogi Guaçu" width="250" height="72" />
                  </a>
                </h1>
              </div>
            </div>
        </div>
        <div class="menu">
            <div class="topnav" id="myTopnav">
                <a href="/index.php" target="_top" class="btn" title="Home" id="Home"> <i class="ti ti-home"></i> Home</a>
                <bottom href="javascript:void(0);" class="icon" onclick="menuTopo()">
                    <span class="topnav-menu">Menu</span>
                    <i class="fa fa-bars"></i>
                </bottom>        
            </div>
        </div>
    </header>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC FIM -->
    <section class="conteudo-geral">
        
        
        <section id="main">
          <div class="container">
            <div class="row">
        	
        	<div class="col-md-3">
            	<div class="list-group">
            		<a href="dashboard.php" class="list-group-item active main-color-bg"><span class="glyphicon glyphicon-cog" aria-hidden="true"></span>
            		Dashboard <span class="badge">23</span>
            		</a>		
            		<a href="posts.php" class="list-group-item"><span class="glyphicon glyphicon-list-alt" aria-hidden="true"></span>Grupos<span class="badge">12</span></a>
            		<a href="categories.php" class="list-group-item"><span class="glyphicon glyphicon-bookmark" aria-hidden="true"></span>Botões<span class="badge">6</span></a>
            		<a href="users.php" class="list-group-item"><span class="glyphicon glyphicon-file" aria-hidden="true"></span>Páginas<span class="badge">21</span></a>
            		<a href="users.php" class="list-group-item"><span class="glyphicon glyphicon-user" aria-hidden="true"></span>Usuários<span class="badge">21</span></a>
            	</div>
            </div>
        	
        	
                <div class="col-md-9">
                  <div class="panel panel-default">
                      <div class="panel-heading" style="background-color:  #095f59;">
                        <h3 class="panel-title">Website Overview</h3>
                      </div>
                      <div class="panel-body">
                       <div class="col-md-3">
                         <div class="well dash-box">
                           <h2><span class="glyphicon glyphicon-list-alt" aria-hidden="true"></span> 21</h2>
                           <h4>Grupos</h4>
                         </div>
                       </div>
                       <div class="col-md-3">
                         <div class="well dash-box">
                           <h2><span class="glyphicon glyphicon-bookmark" aria-hidden="true"></span> 6</h2>
                           <h4>Botões</h4>
                         </div>
                       </div>
                       <div class="col-md-3">
                         <div class="well dash-box">
                           <h2><span class="glyphicon glyphicon-file" aria-hidden="true"></span>12</h2>
                           <h4>Páginas</h4>
                         </div>
                       </div>
                       <div class="col-md-3">
                         <div class="well dash-box">
                           <h2><span class="glyphicon glyphicon-user" aria-hidden="true"></span>12</h2>
                           <h4>Usuários</h4>
                         </div>
                       </div>  
                      </div>
                    </div>
                </div>
            </div>
          </div>
        </section>
        
        
        
      
    </section>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE INICIO -->
    <footer class="rodape">
      <div class="rodape-container">
        <div class="rodape-texto">
          <div class="end-rodape-1">Rua Henrique Coppi, nº 200 Centro <br />CEP: 13820-641 | +55 (19) 3851-7000 </div>
          <div class="end-rodape-2">Rua Henrique Coppi, nº 200 <br /> +55 (19) 3851-7000 </div>
        </div>
        <div class="rodape-brasao">
          <div class="rodape_brasao_img">
            <img src="../images/guacuDigital.svg" alt="Guaçu Digital" width="127" height="50" />
          </div>
        </div>
        <div class="rodape-mapadosite">
                Secretaria de Tecnologia e Inovação
            </br>
                Departamento de Tecnologia
            </br>
                2024
        </div>
      </div>
      <div style="text-align: center; width: 100%;">
            <a style="color: #fff;font-family: MyriadPro;" href="politica-de-privacidade-e-termo-de-uso.html" target="_blank">Política de privacidade</a>
        </div>
    </footer>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE FIM -->
    
    <!-- Janela de Verificação do Cookie -->
    <div id="janela-aviso">
        <span class="close-lgpd">&times;</span>
        <div class="modal-body">
            <p>Usamos cookies para tornar sua experiencia a mais agradável possível.</p>
            <p>Se continuar navegando neste site, você assume concordar com nossa,  
            <a href="politica-de-privacidade-e-termo-de-uso.html" target="_blank">POLÍTICA DE COOKIES E REGISTRO DE NAVEGAÇÃO</a>.</p>
        </div>
        <div align="center" style="margin-top: 10px;">
            <button class="btn-lgpd" id="btnAceiteLGPD">Entendi e aceito</button>
        </div>
    </div>
        
   


</html>