<?php

    // Initialize the session
    session_start();
    
    // Check if the user is logged in, if not then redirect him to login page
    if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true){
        header("location: index.php");
        exit;
    }

?>

<html>
    <head>
      <title>Portal - Guaçu Digital - Admin</title>
      
      
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
      
        <script type="text/javascript" language="javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    	<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    	<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
    	
    	<script type="text/javascript" language="javascript" src="js/hexa-to-rgb-color.js"></script>
      
        <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.6.0/js/bootstrap.min.js"></script>
        <script src="https://cpwebassets.codepen.io/assets/common/stopExecutionOnTimeout-2c7831bb44f98c1391d6a4ffda0e1fd302503391ca806e7fcc7b9b87197aec26.js"></script>
      
      
        <style>
            body {
                margin:0;
                padding:0;
                background-color:#f1f1f1;
            }
            .box {
                /* width:1280px; */
                width: 95%;
                max-width: 1920px !important;
                padding:20px;
                background-color:#fff;
                border:1px solid #ccc;
                border-radius:5px;
                margin-top:25px;
            }
            .pixel {
                display: inline-block;
                background-color: #000;
                width: 50px;
                height: 50px;
            }
            .filterDetail {
                font-family: "Consolas", "Menlo", "Ubuntu Mono", monospace;
            }
            .iconpreview {
                max-width: 60px;
                max-height: 60px;
                filter: invert(100%) sepia(0%) saturate(7499%) hue-rotate(65deg) brightness(100%) contrast(104%);
                height: 100%;
            }
            .modal-dialog {
                max-width: 610px;
                margin: 0 auto;
                padding: 20px;
                background-color: #fff;
                border-radius: 10px;
                box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            }
            .modal-title {
                color: #333;
             }
            .modal-body {
                margin-bottom: 10px;
            }
            label {
                font-weight: bold;
            }
            .form-control {
                width: 100%;
                /*padding: 8px;*/
                border: 1px solid #ccc;
                border-radius: 4px;
                box-sizing: border-box;
                margin-bottom: 10px;
            }
            textarea {
                width: 100%;
                padding: 8px;
                border: 1px solid #ccc;
                border-radius: 4px;
                box-sizing: border-box;
            }
            select {
                width: 100%;
                padding: 8px;
                border: 1px solid #ccc;
                border-radius: 4px;
            }
            button {
                padding: 8px 15px;
                background-color: #19837f;
                color: #fff;
                border: none;
                border-radius: 4px;
                cursor: pointer;
            }
            button:hover {
                background-color: #156d6b;
            }
              
            .pickcolor{
            	align-items: center;
            	text-align: center;
            }
            .container {
                max-width: 1280px;
            }
        </style>
    </head>
    <body>
      <div class="container box">
       <h1 align="center"></h1>
       <br />
       <div class="table-responsive">
        <br />
        <div align="right">     
         <button type="button" id="add_button" data-toggle="modal" data-target="#buttonModal" class="btn btn-info btn-lg">Adicionar Botão</button>
        </div>
        <br /><br />
    
        <table id="button_data" class="table table-striped table-bordered" style="width:100%">
         <thead>
          <tr>
           <th>Icone</th>
           <th>Rotulo</th>
           <th>Tags</th>
           <th>Descrição</th>
           <th>Url</th>
           <th>Grupo</th>
           <th>Status</th>
           <th>Editar</th>
           <th>Remover</th>
          </tr>
         </thead>
        </table>
        
       </div>
      </div>
    </body>
</html>


<div id="buttonModal" class="modal fade">
	<div class="modal-dialog">
		<form method="post" id="button_form" enctype="multipart/form-data">
			<div class="modal-content">
				<div class="modal-header">					
					<h4 class="modal-title">Adicionar Botão</h4>
				</div>
				<div class="modal-body">
					<label>Rotulo do botão:</label>
					<input type="text" name="label" id="label" class="form-control">
					<br>

					<label>URL do Botão:</label>
					<input type="text" name="url" id="url" class="form-control">
					
					<br>
										
					<label>Descrição:</label>
					<textarea name="shorttext" id="shorttext" rows="2" cols="78">Pequeno texto descritivo</textarea>
						
					<br>
										
					<label>Tags:</label>
							
					<br>
							
					<textarea name="tags" id="tags" rows="2" cols="78">Exemplo(boleto,arrecadação...)</textarea>
							
					<br>
					<br>

					<label for="categoria">Grupo:</label>
							
					<br>
							
					<select name="categoria" id="categoria">

						<?php
                            // Replace 'your_database.db' with the path to your SQLite database file
                            $dbname = 'database/digital.db';
                            
                            try {
                                // Create a new SQLite PDO connection
                                $conn = new PDO("sqlite:$dbname");
                                $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                            
                                // Consulta para obter os grupos da tabela "grupo"
                                $sqlGrupos = "SELECT * FROM groups ORDER BY name ASC";
                                $resultGrupos = $conn->query($sqlGrupos);
                                
                            
                                // Laço para imprimir os grupos e as imagens relacionadas a eles
                                if ($resultGrupos->rowCount() > 0) {
                                    foreach ($resultGrupos as $rowGrupo) {
                                        echo '<option value="' . $rowGrupo["id_group"] . '" class="form-control">' . $rowGrupo["name"] . '</option>';
                                    }
                                } else {
                                    echo "Nenhum grupo encontrado na tabela.";
                                }
                            
                                // Close the database connection (optional, as PDO closes automatically when the script ends)
                                $conn = null;
                            } catch (PDOException $e) {
                                die("Connection failed: " . $e->getMessage());
                            }
                        ?>          
						
					</select>
					
					<br><br>
					
					<input type="radio" id="enable" name="is_active" value="1">
                    <label for="enable">habilitado</label>
              
                    <input type="radio" id="disable" name="is_active" value="0">
                    <label for="disable">desabilitado</label><br>

					
										
					<fieldset>
									
						<label>Escolher imagem</label>
						<input type="file" name="icon_image" id="icon_image" onchange="loadFile(event)">
						<span id="icon_uploaded_image"></span>
											
						<br> 
						<br>						
						
						<div class="row pickcolor">
						  <div class="col-sm">
							<label for="favcolor">Cor do fundo:</label>
							<input type="color" class="target" id="bgroundcolor" name="backgroundpcolor" value="#000">
						  </div>
						  <div class="col-sm">
							<label for="favcolor">Cor do Icone:</label>
							<input type="color" class="target" id="iconcolor" name="groupcolor" value="#ffffff">
						  </div>
						  <div class="col-sm">
							<button class="execute">Aplicar cor</button>
						  </div>
						</div>					
						
						<br> 
						<br>
										
					</fieldset>
									  
					<div id="iconbg" style="display: flex; justify-content: center; align-items: center; width: 100px; height: 100px; margin-top:5px; border-radius: 5px; background: #000; text-align: center; font-size: 30px; line-height: 55px; color: #ffffff;">
						<span style="width: 60px; height: 60px;">
							<img class="iconpreview" id="output">
						</span>  
					</div>					
				</div>
				<div class="modal-footer">
						<input type="hidden" name="id_button" id="id_button">
						<input type="hidden" name="operation" id="operation" value="Add">
						<input type="hidden" name="iconcolor" id="piccolor">
						<input type="hidden" name="bgcolor" id="bgcolor">
						<input type="submit" name="action" id="action" class="btn btn-success" value="Add">
						<button type="button" class="btn btn-danger" data-dismiss="modal">Fechar</button>
				</div>
			</div>
		</form>
	</div>
</div>

<script>
    $(document).ready(function(){
        var groupColors = {};

        function loadGroupColors() {
            $.ajax({
                url: "loadGroupColors.php",
                method: "POST",
                success: function(data) {
                    groupColors = JSON.parse(data);
                }
            });
        }

        loadGroupColors();

        $('#categoria').change(function() {
            var selectedGroupId = $(this).val();
            if (selectedGroupId in groupColors) {
                var selectedGroupColor = groupColors[selectedGroupId];
                $('#bgroundcolor').val(selectedGroupColor);
                $('#iconbg').css('background-color', selectedGroupColor);
            }
        });
    });    
</script>        

<!-- Image upload preview -->
<script>
  var loadFile = function(event) {
    var output = document.getElementById('output');
    output.src = URL.createObjectURL(event.target.files[0]);
    output.onload = function() {
      URL.revokeObjectURL(output.src) // free memory
    }
  };
</script>

<script>
$(document).ready(() => {
  $('button.execute').click((event) => { 
    event.preventDefault()
    const rgb = hexToRgb($('input#iconcolor').val());
    const bg = $('input#bgroundcolor').val()
    if (rgb.length !== 3) {
      alert('Invalid format!');
      return;
    }

    const color = new Color(rgb[0], rgb[1], rgb[2]);
    const solver = new Solver(color);
    const result = solver.solve();

    let lossMsg;
    if (result.loss < 1) {
      lossMsg = 'This is a perfect result.';
    } else if (result.loss < 5) {
      lossMsg = 'The is close enough.';
    } else if (result.loss < 15) {
      lossMsg = 'The color is somewhat off. Consider running it again.';
    } else {
      lossMsg = 'The color is extremely off. Run it again!';
    }

    $('.realPixel').css('background-color', color.toString());
    $('#iconbg').css('background-color', bg.toString());
    $('.iconpreview').attr('style', result.filter);
    $('.filterPixel').attr('style', result.filter);
    $('.filterDetail').text(result.filter);
    $('.lossDetail').html(`Loss: ${result.loss.toFixed(1)}. <b>${lossMsg}</b>`);
    $('#bgcolor').val(bg.toString());
    $('#piccolor').val(result.filter.toString());
  });
});
</script>


<script type="text/javascript" language="javascript" >
$(document).ready(function(){

 $('#add_button').click(function(){
  $('#button_form')[0].reset();
  $('.modal-title').text("Adicionar Botão");
  $('#action').val("Add");
  $('#operation').val("Add");
  $('#icon_uploaded_image').html('');
 }); 

 $(document).on('submit', '#button_form', function(event){
  event.preventDefault();
  var label = $('#label').val();
  var url = $('#url').val();
  var categoria = $('#categoria').val();
  
   
  
  var extension = $('#icon_image').val().split('.').pop().toLowerCase();
  if(extension != '')
  {
   if(jQuery.inArray(extension, ['gif','png','jpg','jpeg','svg']) == -1)
   {
    alert("Invalid Image File");
    $('#icon_image').val('');
    return false;
   }
  } 
  if(label != '' && url != '' && categoria != '')
  {

   $.ajax({
    url:"buttonInsert.php",
    method:'POST',
    data:new FormData(this),
    contentType:false,
    processData:false,
    success:function(data)
    {
     alert(data);
     $('#button_form')[0].reset();
     $('#buttonModal').modal('hide');
     dataTable.ajax.reload();
    }
   });
  }
  else
  {
   alert("Both Fields are Required");
  }
 });

 var dataTable = $('#button_data').DataTable({
  "processing":true,
  "serverSide":true,
  "order":[],
  "ajax":{
   url:"buttonFetch.php",
   type:"POST"
  },
  "columnDefs":[
   {
    "targets":[0, 7, 8],
    "orderable":false,
   },
  ],
  "columns": [ 
  ]
 });

 
 $(document).on('click', '.update', function(){
     
  var id_button = $(this).attr("id_button");
  $.ajax({
   url:"buttonFetch_single.php",
   method:"POST",
   data:{id_button:id_button},
   dataType:"json",
   success:function(data)
   {
    $('#buttonModal').modal('show');
    $('.modal-title').text("Editar Botão");
    
    $('#icon_uploaded_image').html(data.icon);
    $('#label').val(data.label);
    $('#shorttext').val(data.shorttext);
    $('#tags').val(data.tags);
    $('#url').val(data.url);
    $('#categoria').val(data.id_group);
    $('#bgroundcolor').val(data.bgcolor.toString());
    $('#id_button').val(id_button);
    
    $('#iconbg').css('background-color', data.bgcolor.toString());
    $('.iconpreview').attr('style', (data.iconcolor.toString()));
    
    // Check the radio button based on the value of is_active
    if (data.is_active == 1) {
        $('#enable').prop('checked', true);
    } else {
        $('#disable').prop('checked', true);
    }
    
    $('#bgcolor').val(data.bgcolor.toString());
    $('#piccolor').val(data.iconcolor.toString());
    
    
    $('#action').val("Edit");
    $('#operation').val("Edit");
    
    $('#output').attr('src', $('#icon').attr('src'));
    
   }
  })
 });
 
 $(document).on('click', '.delete', function(){
  var id_button = $(this).attr("id_button");
  if(confirm("Are you sure you want to delete this?"))
  {
   $.ajax({
    url:"buttonDelete.php",
    method:"POST",
    data:{id_button:id_button},
    success:function(data)
    {
     alert(data);
     dataTable.ajax.reload();
    },
    error: function (data) {
        alert(JSON.stringify(data));
    }
   });
  }
  else
  {
   return false; 
  }
 });
 
 
});
</script>