<?php

require ('dbconnection.php');

require ('database/digital.php');

function get_total_all_records($conn)
{
    $statement = $conn->prepare("SELECT * FROM groups");
    $statement->execute();
    $result = $statement->fetchAll();
    return count($result);
}

try {
    
    $query = '';
    $output = array();
    $query .= "SELECT * FROM groups ";
    
    if (isset($_POST["search"]["value"])) {
        $query .= 'WHERE name LIKE "%' . $_POST["search"]["value"] . '%" ';
    }
    if (isset($_POST["order"])) {
        $query .= 'ORDER BY ' . $_POST['order']['0']['column'] . ' ' . $_POST['order']['0']['dir'] . ' ';
    } else {
        $query .= 'ORDER BY id_group DESC ';
    }
    if ($_POST["length"] != -1) {
        $query .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
    }
    
    $statement = $conn->prepare($query);
   
    $statement->execute();
    $result = $statement->fetchAll();
    $data = array();
    $filtered_rows = count($result);
    
    foreach ($result as $row) {
        
        $sub_array = array();
        $sub_array[] = $row["name"];
        $sub_array[] = '<div style="background-color: ' . $row["color"] . '; width: 100%; height: 22px;"></div>';
        $sub_array[] = ($row["is_active"] == 1) ? '<span class="btn btn-success" disabled>Ativo</span>' : '<span class="btn btn-danger btn-xs" disabled>Inativo</span>';
        $sub_array[] = '<button type="button" name="update" id_group="' . $row["id_group"] . '" class="btn btn-warning btn-xs update">Editar</button>';
        $sub_array[] = '<button type="button" name="delete" id_group="' . $row["id_group"] . '" class="btn btn-danger btn-xs delete">Remover</button>';
        $data[] = $sub_array;
    }
    
    $output = array(
        "draw" => intval($_POST["draw"]),
        "recordsTotal" =>  $filtered_rows,
        "recordsFiltered" => get_total_all_records($conn),
        "data" => $data
    );
    
    echo json_encode($output);
    
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}
?>
