<?php
session_start();

$database = new SQLite3('database/digital.db');

// Check if the user is already logged in
if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true) {
    //if ($_SESSION["username"] === "admin") {
        header("location: admin.php");
    //} else {
        //header("location: pages.php");
    //}
    //exit;
}

$login_err = ""; // Inicializa a variável de erro

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST["username"]);
    $password = trim($_POST["password"]);

    // Validate credentials
    $stmt = $database->prepare("SELECT id_user, username, role, password FROM users WHERE username = :username");
    $stmt->bindValue(':username', $username, SQLITE3_TEXT);
    $result = $stmt->execute();

    if ($row = $result->fetchArray(SQLITE3_ASSOC)) {
        if (password_verify($password, $row['password'])) {
            // Password is correct, start a new session
            $_SESSION["loggedin"] = true;
            $_SESSION["id"] = $row['id_user'];
            $_SESSION["username"] = $row['username']; // Usa o nome de usuário do banco
            $_SESSION["role"] = $row['role'];

            // Redirecionamento com base no nome de usuário
            //if ($row['username'] === "admin") {
                header("location: admin.php");
            //} else {
                //header("location: pages.php");
            //}
            //exit;
        } else {
            $login_err = "Usuário ou senha inválido!";
        }
    } else {
        $login_err = "Usuário ou senha inválido!";
    }
}
?>


<!doctype html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="initial-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">    
    <meta name="msapplication-tap-highlight" content="no"/>
    <link rel="shortcut icon" href="https://mogiguacu.sp.gov.br/images/favicon.ico">
    <link href='http://fonts.googleapis.com/css?family=Roboto:300,400,500' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="css/flat.css"/>
    <link rel="stylesheet" href="css/login_page.css" />
    
     <style>
      #error-message {
          margin: 20px 0 0 0;
          color: red;
          font-weight: bold;
          display: flex;
          align-items: center;
          flex-direction: column;
        }
    </style>

	
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
		$(document).ready(function() {
			$('#login-form').submit(function(event) {
				var username = $('#login_username').val();
				var password = $('#login_password').val();

				if (username === '' || password === '') {
					event.preventDefault(); // Prevent form submission
					$('#error-message').text('Por favor, insira usuário e senha!').show();
				} else {
					$('#error-message').hide();
					// Allow form submission to proceed
				}
			});
		});
	</script>



    <title>Página de acesso</title>
</head>
<body class="login_page">

    <div class="login_page_wrapper">
        <div class="md-card" id="login_card">
            <div class="md-card-content large-padding" id="login_form">
                <div class="login_heading">
                    <div class="user_avatar"></div>
                </div>
                <form id="login-form" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
					<div class="uk-form-row">
						<label for="login_username">Usuário</label>
						<input class="md-input" type="text" id="login_username" name="username" />
					</div>
					<div class="uk-form-row">
						<label for="login_password">Senha</label>
						<input class="md-input" type="password" id="login_password" name="password" />
					</div>
					<div class="uk-margin-medium-top">
						<input type="submit" class="md-btn md-btn-primary md-btn-block md-btn-large" value="Entrar">
					</div>
					<div id="error-message" style="color: red;">
						<?php if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($login_err)) { echo $login_err; } ?>
					</div>
				</form>
				
                    <div class="user_avatar_footer"></div>
                
            </div>           
        </div>        
    </div>   
    

</body>
</html>