<?php

session_start(); // Inicia a sessão

require ('dbconnection.php');
require ('database/digital.php');

function get_total_all_records($conn, $user_role)
{
    // Se o usuário for admin, não faz filtro de pagegroup
    if ($user_role === 'admin') {
        $statement = $conn->prepare("SELECT * FROM pages");
    } else {
        $statement = $conn->prepare("SELECT * FROM pages WHERE pagegroup = :role");
        $statement->bindParam(':role', $user_role, PDO::PARAM_INT);
    }
    $statement->execute();
    $result = $statement->fetchAll();
    return count($result);
}

try {
    // Verifica se o usuário está autenticado e tem um role definida
    if (!isset($_SESSION['role'])) {
        die(json_encode(["error" => "Usuário não autenticado ou sem role definida."]));
    }

    
	$user_role = intval($_SESSION['role']); // Garante que o valor seja um número inteiro

    // Se o usuário for admin, exibe todos os registros
    if ($user_role === 1) {
        $query = "SELECT pages.*, pages.pagename 
                  FROM pages 
                  LEFT JOIN groups ON pages.pagegroup = groups.id_group 
                  LEFT JOIN buttons ON pages.page_icon = buttons.id_button";
    } else {
        $query = "SELECT pages.*, pages.pagename 
                  FROM pages 
                  LEFT JOIN groups ON pages.pagegroup = groups.id_group 
                  LEFT JOIN buttons ON pages.page_icon = buttons.id_button 
                  WHERE pages.pagegroup = :role"; // Filtrando pelo role do usuário
    }

    $conditions = [];

    // Aplicar filtro de pesquisa se houver um valor enviado
    if (isset($_POST["search"]["value"]) && !empty($_POST["search"]["value"])) {
        $search_value = '%' . $_POST["search"]["value"] . '%';
        $conditions[] = "(pagename LIKE :search OR url_slug LIKE :search OR pagegroup LIKE :search)";
    }

    // Adicionar condições extras à cláusula WHERE
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }

    // Aplicar ordenação
    if (isset($_POST["order"])) {
        $query .= ' ORDER BY ' . $_POST['order']['0']['column'] . ' ' . $_POST['order']['0']['dir'];
    } else {
        $query .= ' ORDER BY id_page DESC';
    }

    // Aplicar paginação
    if ($_POST["length"] != -1) {
        $query .= ' LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
    }

    $statement = $conn->prepare($query);
    
    // Bind dos parâmetros
    if ($user_role !== 1) {
        $statement->bindParam(':role', $user_role, PDO::PARAM_INT);
    }

    if (isset($_POST["search"]["value"]) && !empty($_POST["search"]["value"])) {
        $statement->bindParam(':search', $search_value, PDO::PARAM_STR);
    }

    $statement->execute();
    $result = $statement->fetchAll();
    $data = array();
    $filtered_rows = count($result);

    foreach ($result as $row) {
        $sub_array = array();
        $sub_array[] = $row["id_page"];
        $sub_array[] = $row["pagename"];
        $sub_array[] = $row["url_slug"];
        $sub_array[] = $row["pagegroup"];
        $sub_array[] = ($row["is_active"] == 1) ? '<span class="btn btn-success" disabled>Ativo</span>' : '<span class="btn btn-danger btn-xs" disabled>Inativo</span>';
        $sub_array[] = '<button type="button" name="update" id_page="' . $row["id_page"] . '" class="btn btn-warning btn-xs update">Editar</button>';
        $sub_array[] = '<button type="button" name="delete" id_page="' . $row["id_page"] . '" class="btn btn-danger btn-xs delete">Remover</button>';
        $data[] = $sub_array;
    }

    $output = array(
        "draw" => intval($_POST["draw"]),
        "recordsTotal" => get_total_all_records($conn, $user_role),
        "recordsFiltered" => $filtered_rows,
        "data" => $data
    );

    echo json_encode($output);

} catch (PDOException $e) {
    die(json_encode(["error" => "Connection failed: " . $e->getMessage()])); 
}
?>
