<?php

    require ('dbconnection.php');
    
    require ('database/digital.php');
    
    try {
    
        // if (isset($_POST["id_page"])) {
        //     $output = array();
        //     $statement = $conn->prepare("SELECT * FROM pages WHERE id_page = :id_page LIMIT 1");
        //     $statement->bindParam(':id_page', $_POST["id_page"], PDO::PARAM_INT);
        //     $statement->execute();
        //     $result = $statement->fetchAll();
    
        //     foreach ($result as $row) {
        //         $output["pagename"] = $row["pagename"];
        //         $output["pagegroup"] = $row["pagegroup"];
        //         $output["page_icon"] = $row["page_icon"];
        //         $output["pagecontent"] = $row["pagecontent"];
        //         $output["is_active"] = $row["is_active"];
        //     }
    
        //     echo json_encode($output);
        // }
        
        
        if (isset($_POST["id_page"])) {
            $output = array();
            $statement = $conn->prepare("
                SELECT 
                    p.*, 
                    b.* 
                FROM 
                    pages p 
                INNER JOIN 
                    buttons b 
                ON 
                    p.page_icon = b.id_button 
                WHERE 
                    p.id_page = :id_page 
                LIMIT 1
            ");
            $statement->bindParam(':id_page', $_POST["id_page"], PDO::PARAM_INT);
            $statement->execute();
            $result = $statement->fetchAll();
            
            foreach ($result as $row) {
                // Dados da tabela pages
                $output["pagename"] = $row["pagename"];
                $output["pagegroup"] = $row["pagegroup"];
                $output["page_icon"] = $row["page_icon"];
                $output["url"] = $row["url_slug"];
                $output["pagecontent"] = $row["pagecontent"];
                $output["is_active"] = $row["is_active"];
                
                // Dados da tabela buttons
                $output["label"] = $row["label"];
                $output["tags"] = $row["tags"];
                $output["shorttext"] = $row["shorttext"];
                //$output["url"] = $row["url"];
                $output["bgcolor"] = $row["bgcolor"];
                $output["iconcolor"] = $row["iconcolor"];
                $output["id_group"] = $row["id_group"];
        
                if ($row["icon"] != '') {
                    $output['icon'] = '<img src="../images/uploads/' . $row["icon"] . '" class="img-thumbnail" id="icon" width="50" height="35" /><input type="hidden" name="hidden_icon" value="' . $row["icon"] . '" />';
                } else {
                    $output['icon'] = '<input type="hidden" name="hidden_icon" value="" />';
                }
            }
            
            echo json_encode($output);
        }
        
        
    } catch (PDOException $e) {
        die("Connection failed: " . $e->getMessage());
    }
?>