<?php
  /***************************************************
   * Only these origins are allowed to upload images *
   ***************************************************/
  $accepted_origins = array("https://digital.mogiguacu.sp.gov.br");

  /*********************************************
   * Change this line to set the upload folder *
   *********************************************/
  $imageFolder = "../uploadfiles/";

  if (isset($_SERVER['HTTP_ORIGIN'])) {
    // same-origin requests won't set an origin. If the origin is set, it must be valid.
    if (in_array($_SERVER['HTTP_ORIGIN'], $accepted_origins)) {
      header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
    } else {
      header("HTTP/1.1 403 Origin Denied");
      return;
    }
  }

  // Don't attempt to process the upload on an OPTIONS request
  if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    header("Access-Control-Allow-Methods: POST, OPTIONS");
    return;
  }

  reset ($_FILES);
  $temp = current($_FILES);
  if (is_uploaded_file($temp['tmp_name'])) {
    /*
      If your script needs to receive cookies, set images_upload_credentials : true in
      the configuration and enable the following two headers.
    */
    // header('Access-Control-Allow-Credentials: true');
    // header('P3P: CP="There is no P3P policy."');

    // Function to remove accents
    function remove_accents($string) {
        $unwanted_array = array(
            'á'=>'a', 'à'=>'a', 'ã'=>'a', 'â'=>'a', 'ä'=>'a',
            'Á'=>'A', 'À'=>'A', 'Ã'=>'A', 'Â'=>'A', 'Ä'=>'A',
            'é'=>'e', 'è'=>'e', 'ê'=>'e', 'ë'=>'e',
            'É'=>'E', 'È'=>'E', 'Ê'=>'E', 'Ë'=>'E',
            'í'=>'i', 'ì'=>'i', 'î'=>'i', 'ï'=>'i',
            'Í'=>'I', 'Ì'=>'I', 'Î'=>'I', 'Ï'=>'I',
            'ó'=>'o', 'ò'=>'o', 'õ'=>'o', 'ô'=>'o', 'ö'=>'o',
            'Ó'=>'O', 'Ò'=>'O', 'Õ'=>'O', 'Ô'=>'O', 'Ö'=>'O',
            'ú'=>'u', 'ù'=>'u', 'û'=>'u', 'ü'=>'u',
            'Ú'=>'U', 'Ù'=>'U', 'Û'=>'U', 'Ü'=>'U',
            'ç'=>'c', 'Ç'=>'C',
            'ñ'=>'n', 'Ñ'=>'N',
            '°'=>''
        );
        return strtr($string, $unwanted_array);
    }

    // Process the file name
    $filename = pathinfo($temp['name'], PATHINFO_FILENAME);
    $extension = pathinfo($temp['name'], PATHINFO_EXTENSION);

    // Convert to uppercase
    $filename = strtoupper($filename);

    // Remove accents
    $filename = remove_accents($filename);

    // Replace spaces with hyphens
    $filename = str_replace(' ', '-', $filename);

    // Combine the filename and extension
    $newFileName = $filename . '.' . $extension;

    // Debugging: Log the sanitized file name
    error_log("Sanitized file name: $newFileName");

    // Sanitize input (recheck after transformations)
    if (preg_match("/([^\w\s\d\-_~,;:\[\]\(\).])|([\.]{2,})/", $newFileName)) {
        header("HTTP/1.1 400 Invalid file name.");
        error_log("Invalid file name after sanitization: $newFileName");
        return;
    }

    // Verify extension
    if (!in_array(strtolower($extension), array("gif", "jpg", "png", "pdf"))) {
        header("HTTP/1.1 400 Invalid extension.");
        return;
    }

    // Accept upload if there was no origin, or if it is an accepted origin
    $filetowrite = $imageFolder . $newFileName;
    if (move_uploaded_file($temp['tmp_name'], $filetowrite)) {
        // Determine the base URL
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on' ? "https://" : "http://";
        $baseurl = $protocol . $_SERVER["HTTP_HOST"] . rtrim(dirname($_SERVER['REQUEST_URI']), "/") . "/";

        // Respond to the successful upload with JSON.
        // Use a location key to specify the path to the saved image resource.
        // { location : '/your/uploaded/image/file'}
        echo json_encode(array('location' => $baseurl . $filetowrite));
    } else {
        // Notify editor that the upload failed
        header("HTTP/1.1 500 Server Error");
        error_log("Failed to move uploaded file to $filetowrite");
    }
  } else {
    // Notify editor that the upload failed
    header("HTTP/1.1 500 Server Error");
    error_log("File upload failed for an unknown reason.");
  }
?>
