<?php

require('dbconnection.php');
require('database/digital.php');

session_start(); // Certifique-se de iniciar a sessão para acessar $_SESSION['username']

function get_total_all_records($conn, $isAdmin, $currentUser)
{
    if ($isAdmin) {
        $statement = $conn->prepare("SELECT * FROM users");
    } else {
        $statement = $conn->prepare("SELECT * FROM users WHERE username = :username");
        $statement->bindParam(":username", $currentUser, PDO::PARAM_STR);
    }
    
    $statement->execute();
    $result = $statement->fetchAll();
    return count($result);
}

try {
    $query = '';
    $output = array();
    $query .= "SELECT * FROM users ";

    $currentUser = $_SESSION['username'] ?? ''; // Obtém o usuário logado
    $isAdmin = ($currentUser === 'admin'); // Verifica se é admin

    if (!$isAdmin) {
        $query .= "WHERE username = :username "; // Restringe a consulta ao próprio usuário
    }

    if (isset($_POST["search"]["value"])) {
        if ($isAdmin) {
            $query .= 'WHERE username LIKE :searchValue ';
        } else {
            $query .= 'AND username LIKE :searchValue ';
        }
    }

    if (isset($_POST["order"])) {
        $query .= 'ORDER BY ' . $_POST['order']['0']['column'] . ' ' . $_POST['order']['0']['dir'] . ' ';
    } else {
        $query .= 'ORDER BY id_user DESC ';
    }

    if ($_POST["length"] != -1) {
        $query .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
    }

    $statement = $conn->prepare($query);

    if (!$isAdmin) {
        $statement->bindParam(":username", $currentUser, PDO::PARAM_STR);
    }

    if (isset($_POST["search"]["value"])) {
        $searchValue = "%" . $_POST["search"]["value"] . "%";
        $statement->bindParam(":searchValue", $searchValue, PDO::PARAM_STR);
    }

    $statement->execute();
    $result = $statement->fetchAll();
    $data = array();
    $filtered_rows = count($result);

    foreach ($result as $row) {
        $sub_array = array();
        $sub_array[] = $row["username"];

        // Formatação da data
        $originalDate = $row["created_at"];
        $timestamp = strtotime($originalDate);
        $formattedDate = date("d-m-Y", $timestamp);
        $sub_array[] = $formattedDate;

        $sub_array[] = '<button type="button" name="update" id_user="' . $row["id_user"] . '" class="btn btn-warning btn-xs update">Atualizar</button>';
        $sub_array[] = '<button type="button" name="delete" id_user="' . $row["id_user"] . '" class="btn btn-danger btn-xs delete">Remover</button>';
        $data[] = $sub_array;
    }

    $output = array(
        "draw" => intval($_POST["draw"]),
        "recordsTotal" => $filtered_rows,
        "recordsFiltered" => get_total_all_records($conn, $isAdmin, $currentUser),
        "data" => $data
    );

    echo json_encode($output);

} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}
