<?php

    require('dbconnection.php');
    require('database/digital.php');

    // Define variables and initialize with empty values
    $username = $password = $confirm_password = "";
    $username_err = $password_err = $confirm_password_err = "";
    $error_messages = array(); // Initialize an array to store error messages

    try {
        if (isset($_POST["operation"])) {
            if ($_POST["operation"] == "Add") {
                
                // Validate username
                if (empty(trim($_POST["username"]))) {
                    $error_messages['username_err'] = "Por favor, entre com um nome de usuário!";
                } elseif (!preg_match('/^[a-zA-Z0-9._]+$/', trim($_POST["username"]))) {
                    $error_messages['username_err'] = "O nome de usuário pode conter apenas letras, números e sublinhados.";
                } else {
                    $users = trim($_POST["username"]);
                    $statement = $conn->prepare("SELECT id_user FROM users WHERE username = ?");
                    $statement->bindParam(1, $users, PDO::PARAM_STR);
                    $statement->execute();
                    $result = $statement->fetchAll();
                    if (count($result) > 0) {
                        $error_messages['username_err'] = "Este nome de usuário já está em uso.";
                    } else {
                        $username = trim($_POST["username"]);
                    }
                }

                // Validate password
                if (empty(trim($_POST["password"]))) {
                    $error_messages['password_err'] = "Por favor, insira uma senha!";
                } elseif (strlen(trim($_POST["password"])) < 6) {
                    $error_messages['password_err'] = "A senha deve ter pelo menos 6 caracteres!";
                } else {
                    $password = trim($_POST["password"]);
                }

                // Validate confirm password
                if (empty(trim($_POST["confirm_password"]))) {
                    $error_messages['confirm_password_err'] = "Por favor, confirme a senha!";
                } else {
                    $confirm_password = trim($_POST["confirm_password"]);
                    if (empty($password_err) && ($password != $confirm_password)) {
                        $error_messages['confirm_password_err'] = "Senhas não combinam!";
                    }
                }

                // Check input errors before inserting in the database
                if (empty($error_messages)) {
                    
                    // Set parameters
                    $param_username = $_POST["username"];
                    $param_password = password_hash($_POST["password"], PASSWORD_DEFAULT);

                    $result = insertUserData(
                        $conn,
                        $param_username,
                        $param_password
                    );
                    $response = array(
                        'success' => true,
                        'message' => 'usuario inserido!'
                    );
                        
                    echo json_encode($response);  
                    
                } else {

                    // Return all error messages
                    $response = array(
                        'success' => false,
                        'error_messages' => $error_messages
                    );
                    echo json_encode($response);
                }
            }

            if ($_POST["operation"] == "Edit") {
                // ... Lógica para validar campos ...
                
                // Validate username
                if (empty(trim($_POST["username"]))) {
                    $error_messages['username_err'] = "Por favor, entre com um nome de usuário!";
                } elseif (!preg_match('/^[a-zA-Z0-9._]+$/', trim($_POST["username"]))) {
                    $error_messages['username_err'] = "O nome de usuário pode conter apenas letras, números e sublinhados.";
                } else {
                    $new_username = trim($_POST["username"]);
                    if ($new_username !== $_POST["original_username"]) { // Check if new username is different
                        $statement = $conn->prepare("SELECT id_user FROM users WHERE username = ?");
                        $statement->bindParam(1, $new_username, PDO::PARAM_STR);
                        $statement->execute();
                        $result = $statement->fetchAll();
                        if (count($result) > 0) {
                            $error_messages['username_err'] = "Este nome de usuário já está em uso.";
                        }
                    }
                }

                // Validate password
                if (empty(trim($_POST["password"]))) {
                    $error_messages['password_err'] = "Por favor, insira uma senha!";
                } elseif (strlen(trim($_POST["password"])) < 6) {
                    $error_messages['password_err'] = "A senha deve ter pelo menos 6 caracteres!";
                } else {
                    $password = trim($_POST["password"]);
                }

                // Validate confirm password
                if (empty(trim($_POST["confirm_password"]))) {
                    $error_messages['confirm_password_err'] = "Por favor, confirme a senha!";
                } else {
                    $confirm_password = trim($_POST["confirm_password"]);
                    if (empty($password_err) && ($password != $confirm_password)) {
                        $error_messages['confirm_password_err'] = "Senhas não combinam!";
                    }
                }
    
                // Check input errors before updating in the database
                if (empty($error_messages)) {
                    // Set parameters
                    $param_username = $_POST["username"];
                    $param_password = password_hash($_POST["password"], PASSWORD_DEFAULT);
    
                    $result = updateUserData(
                        $conn,
                        $param_username,
                        $param_password,
                        $_POST["id_user"]
                    );
    
                    if ($result === NULL) {
                        $response = array(
                            'success' => true,
                            'message' => 'Usuário atualizado!'
                        );
                        echo json_encode($response);
                    }
                } else {
                    // Return all error messages (similar to Add operation)
                    $response = array(
                        'success' => false,
                        'error_messages' => $error_messages
                    );
                    echo json_encode($response);
                }
            }
        }
    } catch (PDOException $e) {
        die("Connection failed: " . $e->getMessage());
    }
?>
