<?php

// Função para escurecer uma cor em hexadecimal

function darkenColor($hex, $percent) {
    // Remover "#" se estiver presente
    $hex = str_replace("#", "", $hex);

    // Converter para RGB
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));

    // Escurecer a cor
    $r = round($r * (1 - $percent));
    $g = round($g * (1 - $percent));
    $b = round($b * (1 - $percent));

    // Garantir que os valores estejam dentro do intervalo [0, 255]
    $r = ($r < 0 || is_nan($r)) ? 0 : (($r > 255) ? 255 : $r);
    $g = ($g < 0 || is_nan($g)) ? 0 : (($g > 255) ? 255 : $g);
    $b = ($b < 0 || is_nan($b)) ? 0 : (($b > 255) ? 255 : $b);

    // Converter de volta para hexadecimal
    $hex = "#" . str_pad(dechex($r), 2, "0", STR_PAD_LEFT) . str_pad(dechex($g), 2, "0", STR_PAD_LEFT) . str_pad(dechex($b), 2, "0", STR_PAD_LEFT);

    return $hex;
}

?>

<!DOCTYPE html>
<html lang="pt-BR">
  
<head>
    
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <meta http-equiv="Content-Language" content="pt-BR">
    <meta name="description" content="Serviços - Prefeitura Municipal de Mogi Guaçu">
    <meta name="author" content="Secretarria de Tecnologia e Inovação - Departamento de Tecnologia">
    <meta name="language" content="pt-BR">
    <meta name="classification" content="E-GOV">

    <link rel="shortcut icon" href="images/favicon.ico" />

    <link href="css/stilo.css" rel="stylesheet"/>
    <link rel="stylesheet" href="css/lgpd.css">
    <link rel="stylesheet" href="css/tabler-icons.min.css">
    
    <script src="js/jquery-3.2.1.min.js"></script>    
    <script src="js/pmmg.js"></script>  
    
    <link rel="stylesheet" href="src/icons/fontawesome5.9.0/css/all.css" />
    <link rel="stylesheet" href="src/css/default.css" />
    <link rel="stylesheet" href="src/css/asb.css" />

    <title>Serviços - Prefeitura Municipal de Mogi Guaçu</title>
    <meta name="keywords" content="Prefeitura Municipal de Mogi Guaçu, Guaçu Digital" />
    
    <style>
        .grupo {
            margin: 0 auto;
            max-width: 960px;
            /* min-height: 80px; */
            display: flex;
            flex-wrap: wrap;
            margin-bottom: 10px;
        }
        .no-results-message {
            width: 100%;
            color: #ff0000; /* Cor do texto */
            font-weight: bold; /* Negrito */
            font-size: 16px; /* Tamanho da fonte */
            text-align: center; /* Alinhamento do texto */
            margin-top: 20px; /* Margem superior */
        }
        #myBtn {
            display: none; /* Começa escondido */
            align-items: center; 
            position: fixed;
            bottom: 5px; /* Alterado para 5px do fundo */
            right: 5px;
            z-index: 99;
            height: 55px;
            width: 55px;
            font-size: 16px;
            border: none;
            outline: none;
            background-color: red;
            color: white;
            cursor: pointer;
            padding: 15px;
            border-radius: 4px;
            transition: bottom 0.3s; /* Adicionado para suavizar a transição */
        }
      
        #myBtn:hover {
            background-color: #555;
        }
        .avisos{
            margin: 10px;
        }
        
    </style>
    
    <link rel="stylesheet" href="css/accessibility.css">
    
</head>
  <body>
      
        <button onclick="topFunction()" id="myBtn" title="Go to top">
            <div class="serv_voltar_seta_img">
                <img src="images/seta_up.svg" alt="Voltar ao topo">
            </div>
            
        </button>
      
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC INICIO -->
    
     <?php include("header.php");  ?>
    
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC FIM -->
    
    <section class="conteudo-geral">
      <!-- SERVICOS -->
      <section>
        <div class="servicos_geral">
        <section class="avisos">
            <a href="https://processos.mogiguacu.sp.gov.br/portal/login.aspx" target="_blank" id="Logotipo" onclick="trackEvent(this)">
               <img src="../images/processos.png" alt="Processos Mogi Guaçu" width="1030" height="291" />
             </a>
        </section>
          <div class="barra_titulo_pesquisa_interna">
            <div class="titulo_pesquisa_interno"> SERVIÇOS </div>
            <div class="busca-interna">
              <form>
                <input name="pesquisa" class="input_pesquisa_interno" placeholder="ACHE O SERVIÇO QUE VOCÊ PROCURA" type="text" id="searchInput" required="required" pattern=".{3,}" title="Mínimo de 3 caracteres" />
                <input type="submit" value="BUSCAR" style="cursor:pointer" class="input_buscar_interno" />
              </form>
            </div>
          </div>
          <section>
              <div id="grupo" class="grupo dp100"></div>
          </section>
          <section>
            <div class="titulo_sections">
              <div class="titulo_sections_titulo">
                <span class='esconde_text_extra'>MAIS ACESSADOS</span>
              </div>
              <div class="titulo_sections_linha"></div>
            </div>
            <div class="servicos">

                <?php
                
                    //Base URL
                    $baseurl = "https://digital.mogiguacu.sp.gov.br/";
                
                    // Caminho para o arquivo do banco de dados SQLite
                    $dbname = 'admin/database/digital.db';
                    
                    try {
                        // Crie uma nova conexão SQLite PDO
                        $conn = new PDO("sqlite:$dbname");
                        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                        
                        // Defina o charset como UTF-8 (não aplicável para SQLite, mas incluído para consistência)
                        $conn->exec("PRAGMA encoding = 'UTF-8';");
                        
                        // Ajuste a consulta SQL para incluir a verificação do status do grupo
                        $sqlBotoesMaisClicados = "
                            SELECT buttons.* 
                            FROM buttons 
                            INNER JOIN groups ON buttons.id_group = groups.id_group 
                            WHERE buttons.is_active = 1 AND buttons.clicks > 0 AND groups.is_active = 1 
                            ORDER BY buttons.clicks DESC 
                            LIMIT 9";
                        
                        $stmtBotoesMaisClicados = $conn->prepare($sqlBotoesMaisClicados);
                        $stmtBotoesMaisClicados->execute();
                        $resultBotoesMaisClicados = $stmtBotoesMaisClicados->fetchAll(PDO::FETCH_ASSOC);
                        
                        // Agora você pode imprimir os 9 botões mais clicados
                        foreach ($resultBotoesMaisClicados as $rowBotao) {
                            echo '<div class="box-servicos">';
                            echo '<a class="lserv" href="' . $rowBotao["url"] . '" target="_blank" id="' . $rowBotao["id_button"] . '" onclick="handleClick(' . $rowBotao["id_button"] . ')">';
                            echo '<div class="box-servicos-icone">';
                            echo '<div class="buttons" style="background: ' . $rowBotao["bgcolor"] . ';">';
                            $backgroundStyle = 'width: 80%; height: 80%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url('. $baseurl .'images/uploads/' . $rowBotao["icon"] . ');';
                            if (pathinfo($rowBotao["icon"], PATHINFO_EXTENSION) === 'svg') {
                                $backgroundStyle .= $rowBotao["iconcolor"];
                            } else {
                                $backgroundStyle .= 'width: 95%; height: 95%;';
                            }
                            echo '<span style="' . $backgroundStyle . '"></span>';
                            echo '</div>';
                            echo '</div>';
                            echo '<div class="box-servicos-texto">';
                            echo '<div class="box-serv-t1">';
                            echo '<h2>' . $rowBotao["label"] . '</h2>';
                            echo '</div>';
                            echo '<div class="box-serv-t2">';
                            echo '<h3>' . $rowBotao["shorttext"] . '</h3>';
                            echo '<h3 class="tags" style="display: none;">' . $rowBotao["tags"] . '</h3>';
                            echo '</div>';
                            echo '</div>';
                            echo '</a>';
                            echo '</div>';
                        }
                        
                        $conn = null;
                    } catch (PDOException $e) {
                        // Em caso de erro na conexão ou em alguma operação com o banco de dados, você pode lidar com isso aqui
                        die("Connection failed: " . $e->getMessage());
                    }

                ?>
              
            </div>
          </section>
          <!-- SERVIÇOS -->
          <section>
              
            <?php
            
                //Base URL
                $baseurl = "https://digital.mogiguacu.sp.gov.br/";
            
                // Caminho para o arquivo do banco de dados SQLite
                $dbname = 'admin/database/digital.db';
                
                try {
                    // Crie uma nova conexão SQLite PDO
                    $conn = new PDO("sqlite:$dbname");
                    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                
                    // Defina o charset como UTF-8 (não aplicável para SQLite, mas incluído para consistência)
                    $conn->exec("PRAGMA encoding = 'UTF-8';");
                
                    // Consulta para obter os grupos da tabela "grupo"
                    $sqlGrupos = "SELECT * FROM groups WHERE is_active = 1 ORDER BY (name = 'Zeladoria') DESC, name ASC";
                    $resultGrupos = $conn->query($sqlGrupos);
                
                    // Consulta para obter as imagens da tabela "botoes" com base no id_grupo
                    $sqlBotoes = "SELECT * FROM buttons WHERE id_group = :id_group AND is_active = 1";
                    $stmtBotoes = $conn->prepare($sqlBotoes);
                
                    // Exemplo de uso: botões de busca para grupo com id_group = 1
                    $id_group = 1;
                    $stmtBotoes->execute(array(':id_group' => $id_group));
                    $buttonsForGroup = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
                
                    // Exemplo de uso: botões de busca para grupo com id_group = 2
                    $id_group = 2;
                    $stmtBotoes->execute(array(':id_group' => $id_group));
                    $buttonsForGroup2 = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC);
    				
    				// Busque os dados dos objetos PDOStatement em arrays
    				$resultGruposArray = $resultGrupos->fetchAll(PDO::FETCH_ASSOC);
    				
    				
                
                    // Laço para imprimir os grupos e os botões relacinados a eles
                    if (count($resultGruposArray) > 0) {
                        foreach ($resultGruposArray as $rowGrupo) {
                            // Definir a cor inicial e a cor escura para este grupo
                            $corInicial = $rowGrupo["color"];
                            $corEscura = darkenColor($corInicial, 0.5); // Escurecer em 50%
                    
                            // Imprimir a div do grupo
                            
                            echo '<div class="int_servico_topico gradient-' . $rowGrupo["id_group"] . '" style="background-color:' . $corInicial . ' ; color:#fff; border-bottom:2px solid ' . $corEscura . '; display:flex;">';
                            	echo '<div class="serv_topico"> ' . $rowGrupo["name"] . ' </div>';
                            	echo '<div style="flex:.3; background:linear-gradient(to right bottom, ' . $corInicial . ' 50%, ' . $corEscura . ' 50%);"></div>';
                            	echo '<div class="serv_voltar_cor1 serv_voltar_cor_flex" style="background-color:' . $corEscura . '">';
                            	//	echo '<div class="serv_voltar_seta_img">';
                            	//		echo '<a href="#">';
                            	//			echo '<img src="images/seta_up.svg" alt="Voltar ao topo">';
                            	//		echo '</a>';
                            	//	echo '</div>';
                            	//	echo '<div class="serv_voltar_texto_link">';
                            	//		echo '<a href="#"> VOLTAR AO TOPO </a>';
                            	//	echo '</div>';
                                echo '</div>';   
                            echo '</div>';
                            
                            echo '<div class="int_servicos gradient-' . $rowGrupo["id_group"] . '">';
                            	echo '<fieldset class="fieldset-servicos" style="border-color:' . $corInicial . ' ">';
                            	    //echo '<legend class="legend-fieldset-servicos" style="color:' . $corInicial . '">SERVI&#199;OS DA SECRETARIA</legend>';
                            	    echo '<div class="int_servicos_hotsite">';
                            
                            $stmtBotoes->execute(array(':id_group' => $rowGrupo["id_group"]));
                            $resultBotoesArray = $stmtBotoes->fetchAll(PDO::FETCH_ASSOC); 
                            
                            $botaoRelacionado = false; // Variável de controle para verificar se há botões relacionados
                                                
                            foreach ($resultBotoesArray as $rowBotao) { 
                                $botaoRelacionado = true; // Há pelo menos um botão relacionado
                                    	echo '<div class="int_box-servicos">';
                                        	echo '<div class="int_box-servicos-icone">';
                                            	echo '<a href="' . $rowBotao["url"] . '" target="_blank" onclick="handleClick(' . $rowBotao["id_button"] . ')">'; // Abre a tag do link
                                            	echo '<div class="buttons" style="background: ' . $rowBotao["bgcolor"] . ';">';
                                            	$backgroundStyle = 'width: 80%; height: 80%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url('. $baseurl .'images/uploads/' . $rowBotao["icon"] . ');';
                                            	if (pathinfo($rowBotao["icon"], PATHINFO_EXTENSION) === 'svg') {
                                            		$backgroundStyle .= $rowBotao["iconcolor"];
                                            	} else {
                                            		$backgroundStyle .= 'width: 95%; height: 95%;';
                                            	}
                                            	echo '<span style="' . $backgroundStyle . '"></span>';
                                            	echo '</div>';    
                                            	echo '</a>'; // Fecha a tag do link
                                        	echo '</div>';
                                        	echo '<div class="int_box-servicos-texto">';
                                            	echo '<a href="' . $rowBotao["url"] . '" target="_blank">';
                                                	echo '<div class="int_box-serv-t1">';
                                                	    echo '<h2> ' . $rowBotao["label"] . ' </h2>';
                                                	echo '</div>';
                                                	echo '<div class="int_box-serv-t2">';                    
                                                	    echo '<h3> ' . $rowBotao["shorttext"] . ' </h3>';
                                                	    echo '<h3 class="tags" style="display: none;">' . $rowBotao["tags"] . '</h3>';
                                                	echo '</div>';
                                            	echo '</a>';
                                        	echo '</div>';
                                    	echo '</div>';
                            }
                            
                            if (!$botaoRelacionado) {
                                // Se não houver botões relacionados, oculta a div do grupo
                                echo '<style>';
                                echo '.gradient-' . $rowGrupo["id_group"] . ' { display: none!important; }';
                                echo '</style>';
                            }
                            
                                    echo '</div>';
                                echo '</fieldset>';    
                            echo '</div>';
                            
                        }
                    } else {
                        echo "Nenhum grupo encontrado na tabela.";
                    }

                
                    // Feche a conexão com o banco de dados (opcional, pois o PDO fecha automaticamente quando o script termina)
                    $conn = null;
                } catch (PDOException $e) {
                    die("Connection failed: " . $e->getMessage());
                }
                ?> 
                
          </section>
          <!-- SERVIÇOS -->
          
          <!-- acessibilidade -->
          
          <?php include("accessibility.php"); ?>
        
          <!-- FIM acessibilidade -->
          
        </div>
      </section>
      <!-- SERVICOS -->
    </section>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE INICIO -->
    
    <?php include("footer.php"); ?>
    
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE FIM -->
    
    <!-- Janela de Verificação do Cookie -->
    <?php include("lgpd_warning.php"); ?>
    <!-- Fim da Janela de Verificação do Cookie -->
    
    <?php
        if($_GET['cookies']=='4767a7b4d2c76d66714bbd75cc83272b') {
            setcookie("termo_aceite_uso_cookies_pmsjc","true",30);
        } else {
    ?>
        <script src="js/lgpd.js"></script>
    <?php } ?>
    
    <script src="/js/topButton.js"></script>
    
    <script>
        function handleClick(buttonId) {
            // Enviar o ID do botão clicado para o servidor
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    // O código aqui será executado quando a requisição AJAX for concluída com sucesso
                    console.log("Clique registrado com sucesso.");
                }
            };
            xhttp.open("GET", "registrar_clique.php?buttonId=" + buttonId, true);
            xhttp.send();
        }
    </script>
        
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const searchInput = document.getElementById("searchInput");
            const intBoxServicos = document.querySelectorAll(".int_box-servicos");
            const grupoContainer = document.getElementById("grupo");
    
            function filterIntBoxServicos() {
                const searchTerm = searchInput.value.trim().toLowerCase();
                grupoContainer.innerHTML = ''; // Limpa o conteúdo anterior
    
                if (searchTerm === "") {
                    return; // Não faz nada se o campo de busca estiver vazio
                }
    
                let hasResults = false; // Variável para verificar se há resultados
    
                intBoxServicos.forEach(function (intBox) {
                    const h2Text = intBox.querySelector("h2").textContent.toLowerCase();
                    const h3Text = intBox.querySelector("h3").textContent.toLowerCase();
                    const tags = intBox.querySelector(".tags").textContent.toLowerCase();
    
                    if (h2Text.includes(searchTerm) || h3Text.includes(searchTerm) || tags.includes(searchTerm)) {
                        const clonedBox = intBox.cloneNode(true);
                        grupoContainer.appendChild(clonedBox); // Adiciona o box correspondente ao grupoContainer
                        hasResults = true; // Se encontrar pelo menos um resultado, define como true
                    }
                });
    
                if (!hasResults) {
                    // Cria um elemento para exibir a mensagem de "Nenhum resultado encontrado"
                    const noResultsMessage = document.createElement("p");
                    noResultsMessage.textContent = "Nenhum resultado encontrado";
                    noResultsMessage.classList.add("no-results-message"); // Adiciona a classe CSS
                    grupoContainer.appendChild(noResultsMessage);
                }
            }
    
            searchInput.addEventListener("input", filterIntBoxServicos);
        });
    </script>
    
</html>