let mybutton = document.getElementById("myBtn");
let footer = document.getElementById("rodape");
    
window.onscroll = function() { scrollFunction() };
    
function scrollFunction() {
    if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
        mybutton.style.display = "flex";
    } else {
        mybutton.style.display = "none";
    }
    
    let footerHeight = footer.offsetHeight;
    let bottomDistance = `${footerHeight + 3}px`;
    
    if (window.innerWidth < 590) {
        if ((window.innerHeight + window.pageYOffset) >= document.body.offsetHeight - footerHeight - 5) {
            // Se a largura da janela for menor que 590px e estiver próximo ao final da página
            mybutton.style.bottom = bottomDistance;
        } else {
            // Se a largura da janela for menor que 590px e não estiver próximo ao final da página
            mybutton.style.bottom = "70px";
        }
    } else {
        // Para larguras de janela maiores ou iguais a 590px
        if ((window.innerHeight + window.pageYOffset) >= document.body.offsetHeight - footerHeight - 5) {
            if (window.innerWidth < 768) {
                // Se a largura da janela for menor que 768px e estiver próximo ao final da página
                mybutton.style.bottom = bottomDistance;
            } else {
                // Se a largura da janela for maior ou igual a 768px e estiver próximo ao final da página
                mybutton.style.bottom = bottomDistance;
            }
        } else {
            mybutton.style.bottom = "5px";
        }
    }
}
    
function topFunction() {
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
}