<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Language" content="pt-BR">
    <meta name="description" content="Serviços - Prefeitura Municipal de Mogi Guaçu">
    <meta name="author" content="Secretarria de Tecnologia e Inovação - Departamento de Tecnologia">
    <meta name="language" content="pt-BR">
    <meta name="classification" content="E-GOV">
    <link rel="shortcut icon" href="https://mogiguacu.sp.gov.br/images/favicon.ico" />
    <link href="/css/page.css" rel="stylesheet"/>
    <link href="/css/stilo.css" rel="stylesheet"/>
    <link rel="stylesheet" href="/css/lgpd.css">
    <link rel="stylesheet" href="/css/tabler-icons.min.css">
    <script src="/js/jquery-3.2.1.min.js"></script>
    <script src="/js/pmmg.js"></script>
    <link rel="stylesheet" href="src/icons/fontawesome5.9.0/css/all.css" />
    <link rel="stylesheet" href="src/css/default.css" />
    <link rel="stylesheet" href="src/css/asb.css" />
    <title>Serviços - Prefeitura Municipal de Mogi Guaçu</title>
    <meta name="keywords" content="Prefeitura Municipal de Mogi Guaçu, Guaçu Digital" />
    <style>
        body {
            font-family: "Nunito", Helvetica, Arial, sans-serif;
        }
        .no-results-message {
            width: 100%;
            color: #ff0000; /* Cor do texto */
            font-weight: bold; /* Negrito */
            font-size: 16px; /* Tamanho da fonte */
            text-align: center; /* Alinhamento do texto */
            margin-top: 20px; /* Margem superior */
        }
        #conteudo-politica {
            margin: 20px auto;
            line-height: 2em;
            font-family: Helvetica, Arial, sans-serif!important;
            font-size: 14px;
        }
        .conteudo-geral {
            padding: 10px;
        }
        h1 {
            color: #213a73;
            font-size: 1.5em;
            font-weight: bold;
        }
        a {
            color: red;
        }
        #myBtn {
            display: none; /* Começa escondido */
            align-items: center; 
            position: fixed;
            bottom: 5px; /* Alterado para 5px do fundo */
            right: 5px;
            z-index: 99;
            height: 55px;
            width: 55px;
            font-size: 16px;
            border: none;
            outline: none;
            background-color: red;
            color: white;
            cursor: pointer;
            padding: 15px;
            border-radius: 4px;
            transition: bottom 0.3s; /* Adicionado para suavizar a transição */
        }
        #myBtn:hover {
            background-color: #555;
        }
    </style>
    <link rel="stylesheet" href="css/accessibility.css">
</head>
<body>
    <button onclick="topFunction()" id="myBtn" title="Go to top">
        <div class="serv_voltar_seta_img">
            <img src="/images/seta_up.svg" alt="Voltar ao topo">
        </div>
    </button>
    
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC INICIO -->
    <?php include("header.php"); ?>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO CABEC FIM -->
    <section class="conteudo-geral">
        <?php
        // Base URL
        $baseurl = "https://digital.mogiguacu.sp.gov.br/";
        
        // Função para buscar os dados da página com base no url_slug
        function getPageData($conn, $url_slug) {
            $query = "SELECT b.*, p.* FROM buttons b INNER JOIN pages p ON b.id_button = p.page_icon WHERE p.is_active = 1 AND p.url_slug = :url_slug";
            $stmt = $conn->prepare($query);
            if (!$stmt) {
                // Registrar o erro no log
                error_log("Erro na preparação da consulta SQL: " . $conn->lastErrorMsg());
                return null;
            }
            $stmt->bindValue(':url_slug', $url_slug, SQLITE3_TEXT);
            $result = $stmt->execute();
        
            if (!$result) {
                // Registrar o erro no log
                error_log("Erro na execução da consulta SQL: " . $conn->lastErrorMsg());
                return null;
            }
        
            // Extrair os dados da página
            $data = [];
            while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
                $data[] = $row;
            }
            
            return $data;
        }
        
        // Conexão com o banco de dados
        $database = new SQLite3("admin/database/digital.db");
        $database->busyTimeout(5000); // Define um tempo limite de bloqueio de 5 segundos
        
        // Obter url_slug da URL
        $url_slug = isset($_GET['url_slug']) ? $_GET['url_slug'] : '';
        
        // Verificar se o url_slug foi passado na URL
        if (!empty($url_slug)) {
            $pageData = getPageData($database, $url_slug);
            if ($pageData) {
                // Loop para exibir os dados da página
                foreach ($pageData as $row) {
                    echo '<div class="servicos_geral">';
                    echo '<div class="sec_serv_header">';
                    
                    echo '<div class="sec_serv_img">';
                    echo '<div class="buttons" style="background: ' . htmlspecialchars($row["bgcolor"]) . ';">';
                    $backgroundStyle = 'width: 70%; height: 70%; background-size: contain; background-repeat: no-repeat; background-position: center; background-image: url(' . $baseurl . 'images/uploads/' . htmlspecialchars($row["icon"]) . ');';
                    if (pathinfo($row["icon"], PATHINFO_EXTENSION) === "svg") {
                        $backgroundStyle .= htmlspecialchars($row["iconcolor"]);
                    } else {
                        $backgroundStyle .= 'width: 95%; height: 95%;';
                    }
                    echo '<span style="' . $backgroundStyle . '"></span>';
                    echo '</div>';
                    echo '</div>';
                    
                    echo '<div class="sec_serv_descricao">';
                    echo '<h2>' . htmlspecialchars($row["label"]) . '</h2> ' . htmlspecialchars($row["shorttext"]);
                    echo '</div>';
                    echo '</div>';
        
                    echo '<div class="sec_serv_conteudo">';
                    echo '<div class="sec_serv_conteudo_box">';
                    echo $row["pagecontent"];
                    echo '</div>';
                    echo '</div>';
        
                    echo '</div>'; // Fechando div 'servicos_geral'
                }
            } else {
                header("Location: /404.php");
                exit();
            }
        } else {
            header("Location: /404.php");
            exit();
        }
        
        // Fechar a conexão com o banco de dados
        $database->close();
        ?>
        
        <!-- acessibilidade -->
        <?php include("accessibility.php"); ?>
        <!-- FIM acessibilidade -->
    </section>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE INICIO -->
    <?php include("footer.php"); ?>
    <!-- NAO ALTERE OU REMOVA ESTE COMENTARIO RODAPE FIM -->
    <!-- Janela de Verificação do Cookie -->
    <?php include("lgpd_warning.php"); ?>
    <!-- Fim da Janela de Verificação do Cookie -->
    <script src="js/lgpd.js"></script>
    <script src="/js/topButton.js"></script>
</html>
