<?php
// Carregar CSS do tema filho
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style('astra-child-style', get_stylesheet_uri());
});

// Incluir headers.php com múltiplos modelos
require_once get_stylesheet_directory() . '/headers.php';

// Inclui os headers personalizados
require_once get_stylesheet_directory() . '/custom-headers.php';

// Remove o conteúdo padrão do footer "Below Footer"
add_action('init', function () {
    remove_all_actions('astra_footer_copyright');
});

add_filter( 'astra_scroll_to_top_icon', 'custom_scroll_top_icon' );
function custom_scroll_top_icon( $default_svg ) {
    // Novo SVG com ícone personalizado
    $custom_svg = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 20 20" xml:space="preserve">
        <g>
            <path fill="#FFFFFF" d="M9.998,0.236l9.904,9.897H14.95v9.898H5.045v-9.898H0.093L9.998,0.236z"/>
        </g>
    </svg>';

    return $custom_svg;
}


// Adiciona novo conteúdo personalizado ao final do footer
add_action('astra_footer_content_bottom', 'meu_footer_personalizado');
function meu_footer_personalizado() {
    ?>
    <footer id="rodape" class="rodape">
        <div class="rodape-container">
            <div class="rodape-texto">
                <div class="end-rodape-1">
                    Rua Henrique Coppi, nº 200 Centro <br>
                    CEP: 13820-641 | +55 (19) 3851-7000<br>
					Mogi Guaçu - SP
                </div>
                <div class="end-rodape-2">
                    Rua Henrique Coppi, nº 200 <br>
                    +55 (19) 3851-7000<br>
					Mogi Guaçu - SP
                </div>
            </div>

            <div class="rodape-brasao">
                <div class="rodape_brasao_img">                    
                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/guacuDigital.svg" alt="Guaçu Digital" width="127" height="50">                    
                </div>
            </div>

            <div class="rodape-mapadosite">
                Secretaria de Tecnologia e Inovação<br>
                Divisão de Tecnologia<br>
                2025
            </div>
        </div>

        <div class="rodape-container" style="margin-top: 5px;">
            <div class="rodape-texto">
                <a style="color: #fff; font-family: MyriadPro;" href="https://digital.mogiguacu.sp.gov.br/v2/politica-de-privacidade" target="_blank">
                    Política de privacidade
                </a>           
            </div>

            <div class="rodape-mapadosite">
                <div class="rodape_brasao_img">
                    <a style="color: #fff; font-family: MyriadPro;" href="https://digital.mogiguacu.sp.gov.br/v2/faq" target="_blank">
                        Perguntas Frequentes (FAQ)
                    </a>
                </div>
            </div>

            <div class="rodape-mapadosite">
                <a style="color: #fff; font-family: MyriadPro;" href="https://digital.mogiguacu.sp.gov.br/v2/relatar-problema" target="_blank">
                    Encontrou um problema?
                </a>  
            </div>
        </div>
    </footer>
    <?php
}
