document.addEventListener("DOMContentLoaded", function () {
    // Contador de cliques
    document.querySelectorAll(".ga-atalho").forEach(link => {
        link.addEventListener("click", function () {
            const id = this.getAttribute("data-id");
            fetch(ga_vars.ajax_url, {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded"
                },
                body: `action=ga_click&id=${id}`
            });
        });
    });

    // Filtro de pesquisa sem duplicar atalhos
    const input = document.getElementById("ga-search");
    const resultados = document.getElementById("ga-resultados");
    const atalhos = document.querySelectorAll(".ga-atalho");

    if (input && resultados && atalhos.length > 0) {
        input.addEventListener("input", function () {
            const termo = input.value.trim().toLowerCase();
            resultados.innerHTML = '';
            resultados.style.display = termo.length >= 2 ? 'grid' : 'none';

            if (termo.length >= 2) {
                const encontrados = new Set();

                atalhos.forEach(link => {
                    const texto = link.textContent.toLowerCase();
                    const id = link.getAttribute('data-id');

                    if (texto.includes(termo) && !encontrados.has(id)) {
                        resultados.appendChild(link.cloneNode(true));
                        encontrados.add(id);
                    }
                });

                if (resultados.children.length === 0) {
                    const aviso = document.createElement("p");
                    aviso.textContent = "Nenhum resultado encontrado.";
                    resultados.appendChild(aviso);
                }
            }
        });
    }
});
