jQuery(document).ready(function ($) {
    $('#select-svg-button').on('click', function (e) {
        e.preventDefault();
        var frame = wp.media({
            title: 'Selecionar SVG',
            button: { text: 'Usar este SVG' },
            library: { type: 'image' },
            multiple: false
        });

        frame.on('select', function () {
            var attachment = frame.state().get('selection').first().toJSON();
            if (attachment.url.endsWith('.svg')) {
                $('#ga_svg_url').val(attachment.url);
                $('#svg-preview').html('<img src=\"' + attachment.url + '\" style=\"max-width:40px\">');
            } else {
                alert('Selecione um arquivo SVG.');
            }
        });

        frame.open();
    });
});
