<?php
/*
Plugin Name: RTS Aviso de Cookies e Política de Privacidade
Description: Exibe um aviso simples de cookies com link para a política de privacidade.
Version: 1.0
Author: Rafaths - contato@rafaths.com.br
*/

if (!defined('ABSPATH')) exit; // Bloqueia acesso direto

// Carregar CSS e JS
function lgpd_enqueue_scripts() {
    wp_enqueue_style('lgpd-style', plugin_dir_url(__FILE__) . 'lgpd.css');
    wp_enqueue_script('lgpd-script', plugin_dir_url(__FILE__) . 'lgpd.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'lgpd_enqueue_scripts');

// HTML do aviso
function lgpd_cookie_notice() {
    $policy_url = '/v2/politica-de-privacidade'; // <-- Altere aqui se precisar
    ?>
    <div id="janela-aviso">
        <span class="close-lgpd">&times;</span>
        <div class="modal-body">
            <p>Usamos cookies para melhorar a navegação.</p>
            <p>Ao continuar navegando você concorda com a nossa  
            <a href="<?php echo esc_url($policy_url); ?>" target="_blank">Política de Cookies e de Navegação</a>.</p>
        </div>
        <div align="center" style="margin-top: 10px;">
            <button class="btn-lgpd" id="btnAceiteLGPD">Entendi e aceito</button>
        </div>
    </div>
    <?php
}
add_action('wp_footer', 'lgpd_cookie_notice');
