<?php
/*
Plugin Name: RTS Valor do UFIM
Description: Permite definir e exibir o valor do UFIM na grade de atalhos.
Version: 1.0
Author: Rafaths - contato@rafaths.com.br
*/

// ✅ Cria a opção para salvar o valor do UFIM
register_activation_hook(__FILE__, function () {
    if (get_option('valor_ufim') === false) {
        add_option('valor_ufim', '0.00'); // valor padrão
    }
});

// ✅ Adiciona o menu no admin para editar o UFIM
add_action('admin_menu', function () {
    add_menu_page(
        'Valor do UFIM',
        'Valor do UFIM',
        'edit_valor_ufim', // capacidade personalizada
        'valor_ufim',
        'valor_ufim_admin',
        'dashicons-money-alt',
        82
    );
});

// ✅ Capacidade personalizada para editar UFIM
add_action('init', function () {
    $role = get_role('gestor_ufim');
    if (!$role) {
        add_role('gestor_ufim', 'Gestor UFIM', [
            'read' => true,
            'edit_valor_ufim' => true,
        ]);
    } else {
        $role->add_cap('edit_valor_ufim');
    }
    // Adiciona permissão ao administrador também
    $admin = get_role('administrator');
    if ($admin && !$admin->has_cap('edit_valor_ufim')) {
        $admin->add_cap('edit_valor_ufim');
    }
});

// ✅ Página de administração
function valor_ufim_admin() {
    if (!current_user_can('edit_valor_ufim')) {
        wp_die(__('Você não tem permissão para acessar esta página.'));
    }

    if (isset($_POST['valor_ufim'])) {
        check_admin_referer('salvar_valor_ufim');
        $novo_valor = sanitize_text_field($_POST['valor_ufim']);
        update_option('valor_ufim', $novo_valor);
        echo '<div class="notice notice-success"><p>Valor do UFIM atualizado para: R$ ' . esc_html($novo_valor) . '</p></div>';
    }

    $valor_atual = get_option('valor_ufim', '0.00');
    ?>
    <div class="wrap">
        <h1>Definir Valor do UFIM</h1>
        <form method="post">
            <?php wp_nonce_field('salvar_valor_ufim'); ?>
            <table class="form-table">
                <tr>
                    <th><label for="valor_ufim">Valor atual (R$):</label></th>
                    <td><input type="text" id="valor_ufim" name="valor_ufim" value="<?php echo esc_attr($valor_atual); ?>" class="regular-text"></td>
                </tr>
            </table>
            <button type="submit" class="button button-primary">Salvar</button>
        </form>
    </div>
    <?php
}

// ✅ Mostra o UFIM na grade de atalhos
add_action('init', function () {
    // Só se a função `ga_render_atalho` existir (para evitar erro se plugin principal não estiver ativo)
    if (!function_exists('ga_render_atalho')) return;

    add_shortcode('atalho_valor_ufim', function () {
        $valor_ufim = get_option('valor_ufim', '0.00');
        ob_start();
        ?>
        <div class="ga-atalho">
            <div class="ga-atalho-conteudo">
                <h3>Valor do UFIM</h3>
                <p>R$ <?php echo esc_html($valor_ufim); ?></p>
            </div>
        </div>
        <?php
        return ob_get_clean();
    });
});
