<?php
/**
 * Scroll To Top Template - Tema Filho Customizado
 *
 * @package Astra Child
 * @since 1.0.0
 */

// Para evitar execuo no customizer Astra especfico.
if ( is_customize_preview() && ! class_exists( 'Astra_Customizer' ) ) {
    return;
}

// Pega opes do Astra para alinhamento e dispositivos
$astra_addon_scroll_top_alignment = get_theme_mod( 'scroll_to_top_icon_position', 'right' );
$astra_addon_scroll_top_devices   = get_theme_mod( 'scroll_to_top_on_devices', 'both' );

?>

<div id="ast-scroll-top" tabindex="0" class="ast-scroll-top-icon ast-scroll-to-top-<?php echo esc_attr( $astra_addon_scroll_top_alignment ); ?>" data-on-devices="<?php echo esc_attr( $astra_addon_scroll_top_devices ); ?>">
    <!-- SVG personalizado -->
    <svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 20 20" xml:space="preserve" aria-hidden="true" focusable="false">
        <g>
            <path fill="#FFFFFF" d="M9.998,0.236l9.904,9.897H14.95v9.898H5.045v-9.898H0.093L9.998,0.236z"/>
        </g>
    </svg>
    <span class="screen-reader-text"><?php esc_html_e( 'Scroll to Top', 'astra' ); ?></span>
</div>
