<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Controllers\CurlController;

class EventsController
{

    /**
     * GET /get_list
     */
    public function getList(): array
    {
        $errors = [];

        // --- Validação de parâmetros ---
        $token         = $_SESSION['token'] ?? null;

        $missing = [];
        if (!$token) $missing[] = "'token'";

        if ($missing) {
            return [
                'success' => false,
                'data' => [],
                'errors' => [
                    'params' => "Parâmetros obrigatórios faltando: " . implode(', ', $missing)
                ],
            ];
        }

        // --- Consulta API ---
        $url = "https://hub.mogiguacu.sp.gov.br/internals/eventos/";

        $headers = [
            "Authorization: Token $token",
            "Content-Type: application/json"
        ];

        $response = (new CurlController())->curlGet($url, $headers);

        if (!$response) {
            $errors['api'] = 'Erro ao acessar a API';
            return [
                'success' => false,
                'data' => [],
                'errors' => $errors,
            ];
        }

        $data = json_decode($response, true);
        if ($data === null || isset($data['erro'])) {
            $errors['api'] = 'Usuário não encontrado ou resposta inválida';
            return [
                'success' => false,
                'data' => [],
                'errors' => $errors,
            ];
        }

        return [
            'success' => true,
            'data' => $data,
            'errors' => [],
        ];
    }




}