<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Controllers\CurlController;

class LoginController
{

    /**
     * GET /do_login
     */
    public function doLogin(): array
    {
        $errors = [];

        // --- Validação de parâmetros ---
        $re         = $_POST['re'] ?? null;
        $nascimento = $_POST['nascimento'] ?? null;
        $cpf        = $_POST['cpf'] ?? null;

        $missing = [];
        if (!$re) $missing[] = "'re'";
        if (!$nascimento) $missing[] = "'nascimento'";
        if (!$cpf) $missing[] = "'cpf'";

        if ($missing) {
            return [
                'success' => false,
                'data' => [],
                'errors' => [
                    'params' => "Parâmetros obrigatórios faltando: " . implode(', ', $missing)
                ],
            ];
        }

        // --- Consulta BrasilAPI ---
        $url = "https://hub.mogiguacu.sp.gov.br/internals/eventos/user?cpf=" . urlencode($cpf) .
               "&re=" . urlencode($re) .
               "&nascimento=" . urlencode($nascimento);
        // $response = $this->curlGet($url);
        $response = (new CurlController())->curlGet($url);

        if (!$response) {
            $errors['api'] = 'Erro ao acessar a API';
            return [
                'success' => false,
                'data' => [],
                'errors' => $errors,
            ];
        }

        $data = json_decode($response, true);
        if ($data === null || isset($data['erro'])) {
            $errors['api'] = 'Usuário não encontrado ou resposta inválida';
            return [
                'success' => false,
                'data' => [],
                'errors' => $errors,
            ];
        }

        return [
            'success' => $data['auth_token'] ?? false,
            'data' => $data,
            'errors' => [],
        ];
    }

}