<?php
declare(strict_types=1);
namespace App;

class Router
{
    private array $routes = [];

    public function add(string $method, string $path, callable $callback): void
    {
        $this->routes[$method][$path] = $callback;
    }

    public function dispatch(string $path, string $method)
    {
        $callback = $this->routes[$method][$path] ?? null;

        if ($callback === null) {
            return null;
        }

        return $callback();
    }
}
