<?php
namespace App\Core;

class View {
    public static function render(string $view, array $data = []): void {
        // Extrai as variáveis do array para dentro da view
        extract($data);

        $path = __DIR__ . "/../Views/{$view}.php";

        if (!file_exists($path)) {
            throw new \Exception("View {$view} não encontrada em {$path}");
        }

        require $path;
        exit;
    }
}
