<?php
// eventos/app/Views/login.php
$envs = parse_ini_file('.env');
foreach ($envs as $key => $value) { $_ENV[$key] = $value; }
// var_dump($_ENV);
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel="shortcut icon" href="/static/favicon/favicon.ico">
  <title>
    CITY HUB - Mogi Guaçu - Área dos Servidores
  </title>
  <!--     Fonts and icons     -->
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet">
  <link href="https://use.fontawesome.com/releases/v5.0.6/css/all.css" rel="stylesheet">
  <!-- Nucleo Icons -->
  <link href="./assets/css/nucleo-icons.css" rel="stylesheet" />
  <link href="./assets/css/nucleo-svg.css" rel="stylesheet" />
  <!-- Font Awesome Icons -->
  <link href="./assets/css/font-awesome.css" rel="stylesheet" />
  <link href="./assets/css/nucleo-svg.css" rel="stylesheet" />
  <!-- CSS Files -->
  <link href="./assets/css/argon-design-system.css?v=1.2.2" rel="stylesheet" />
</head>

<body class="login-page">
  <!-- Navbar -->
  <!-- Navbar -->
  <nav id="navbar-main" class="navbar navbar-main navbar-expand-lg navbar-transparent navbar-light py-2 mt-2">
    <div class="container">
      <a class="navbar-brand mr-lg-5" href="../index.html">
        <img src="https://digital.mogiguacu.sp.gov.br/wp-content/uploads/2025/07/logo-josi-scaled-278x71.png" alt="Guaçu Digital" style="height: 60px">
      </a>
      <div class="navbar-collapse" id="navbar_global">
        <ul class="navbar-nav align-items-lg-center ml-lg-auto">
          <li class="nav-item">
            <a class="nav-link nav-link-icon" href="https://www.facebook.com/PrefeituradeMogiGuacu/?locale=pt_BR" target="_blank" 
               data-toggle="tooltip" title="Curta no Facebook">
              <i class="fa fa-facebook-square"></i>
              <span class="nav-link-inner--text d-lg-none">Facebook</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link nav-link-icon" href="https://www.instagram.com/prefeituramogiguacu/" target="_blank" 
               data-toggle="tooltip" title="Nos siga no Instagram">
              <i class="fa fa-instagram"></i>
              <span class="nav-link-inner--text d-lg-none">Instagram</span>
            </a>
          </li>
        </ul>
      </div>
    </div>
  </nav>
  <!-- End Navbar -->
  <section class="section section-shaped section-lg">
    <div class="shape shape-style-1 bg-gradient-default">
      <span></span>
      <span></span>
      <span></span>
      <span></span>
      <span></span>
      <span></span>
      <span></span>
      <span></span>
    </div>
    <div class="container pt-lg-7">
      <div class="row justify-content-center">
        <div class="col-lg-5">
          <div class="card bg-secondary shadow border-0">
            <div class="card-body px-lg-5 py-lg-5">
              <div class="text-center text-muted mb-4">
                <h3>Cesta de Natal 2026</h3> <!-- ALTERAR AQUI -->
                <p>Gere seus tiquets aqui a partir de 09/12/2025.</p>
                <?php if (!empty($erro)) : ?>
                    <div class="alert alert-danger">
                        <?= htmlspecialchars($erro) ?>
                    </div>
                <?php endif; ?>
              </div>
              <?php if($_ENV['ATIVO']==true) { ?>
              <form role="form" method="POST" action="/login">
                <div class="form-group mb-3">
                  <div class="input-group input-group-alternative">
                    <div class="input-group-prepend">
                      <span class="input-group-text"><i class="ni ni-circle-08"></i></span>
                    </div>
                    <input id="cpf" name="cpf" class="form-control" placeholder="CPF (ex.: 001.234.456-78)" type="input" required>
                  </div>
                </div>
                <div class="form-group focused">
                  <div class="input-group input-group-alternative">
                    <div class="input-group-prepend">
                      <span class="input-group-text"><i class="ni ni-calendar-grid-58"></i></span>
                    </div>
                    <input id="nascimento" name="nascimento" class="form-control" placeholder="Nascimento (ex.: 01/01/2001)" type="text" required>
                  </div>
                </div>
                <div class="form-group focused">
                  <div class="input-group input-group-alternative">
                    <div class="input-group-prepend">
                      <span class="input-group-text"><i class="ni ni-badge"></i></span>
                    </div>
                    <input id="re" name="re" class="form-control" placeholder="RE (ex.: 123)" type="input" required>
                  </div>
                </div>
                <div class="text-center">
                  <button type="submit" class="btn btn-primary my-4">Login</button>
                </div"
              </form>
              <?php } ?>
            </div>
          </div>          
        </div>
      </div>
    </div>
  </section>
  <!-- Footer -->
    <footer class="footer">
      <div class="container">
        <div class="row row-grid align-items-center mb-5">
          <div class="col-lg-6">
            <h3 class="text-primary font-weight-light mb-2">Guaçu Digital</h3>
            <h4 class="mb-0 font-weight-light">Inovação que aproxima</h4>
          </div>
          <div class="col-lg-6 text-lg-right btn-wrapper">
            <a href="https://www.instagram.com/prefeituramogiguacu/"
                    target="_blank"
                    type="button" class="btn btn-icon-only btn-twitter rounded-circle" 
                    data-toggle="tooltip" data-original-title="Siga">
              <span class="btn-inner--icon"><i class="fa fa-twitter"></i></span>
            </a>
            <a href="https://www.facebook.com/PrefeituradeMogiGuacu/?locale=pt_BR"
                    target="_blank"
                    type="button" class="btn-icon-only rounded-circle btn btn-facebook" 
                    data-toggle="tooltip" data-original-title="Curta">
              <span class="btn-inner--icon"><i class="fab fa-facebook"></i></span>
            </a>
          </div>
        </div>
        <hr>
        <div class="row align-items-center justify-content-md-between">
          <div class="col-md-6">
            <div class="copyright">
              &copy; 2025 Secretaria de Tecnologia e Inovação<br>
              Divisão de Tecnologia | STI/DT/CITYHUB/SERVIDORES 0.0.0<br>
              <!--<small id="app-version"><?=$_SESSION['token'] ?? ''?></small>-->
            </div>
          </div>
          <div class="col-md-6">
            <ul class="nav nav-footer justify-content-end">
              <li class="nav-item">
                <a href="mailto:dev@mogiguacu.sp.gov.br" class="nav-link" target="_blank">Divisão de Tecnologia</a>
              </li>
              <li class="nav-item">
                <a href="https://digital.mogiguacu.sp.gov.br" class="nav-link" target="_blank">Sobre</a>
              </li>
              <li class="nav-item">
                <a href="https://wiki.mogigguacu.sp.gov.br" class="nav-link" target="_blank">Wiki</a>
              </li>
              <li class="nav-item">
                <a href="https://mogiguacu.sp.gov.br" class="nav-link" target="_blank">Prefeitura</a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </footer>
  <!--   Core JS Files   -->
  <script src="./assets/js/core/jquery.min.js" type="text/javascript"></script>
  <script src="./assets/js/core/popper.min.js" type="text/javascript"></script>
  <script src="./assets/js/core/bootstrap.min.js" type="text/javascript"></script>
  <script src="./assets/js/plugins/perfect-scrollbar.jquery.min.js"></script>
  <script src="./assets/js/plugins/bootstrap-switch.js"></script>
  <script src="./assets/js/plugins/nouislider.min.js" type="text/javascript"></script>
  <script src="./assets/js/plugins/moment.min.js"></script>
  <script src="./assets/js/plugins/datetimepicker.js" type="text/javascript"></script>
  <script src="./assets/js/plugins/bootstrap-datepicker.min.js"></script>
  <script src="./assets/js/argon-design-system.min.js?v=1.2.2" type="text/javascript"></script>
  <script src="https://cdn.trackjs.com/agent/v3/latest/t.js"></script>
  <script>
    function cpfMask(value) {
      // remove tudo que não é dígito e corta até 11 dígitos
      value = value.replace(/\D/g, '').slice(0, 11);

      // aplica a máscara passo a passo
      value = value.replace(/^(\d{3})(\d)/, '$1.$2');
      value = value.replace(/^(\d{3})\.(\d{3})(\d)/, '$1.$2.$3');
      value = value.replace(/^(\d{3})\.(\d{3})\.(\d{3})(\d)/, '$1.$2.$3-$4');

      return value;
    }

    const input = document.getElementById('cpf');

    input.addEventListener('input', (e) => {
      const el = e.target;
      const start = el.selectionStart;
      const oldLen = el.value.length;

      el.value = cpfMask(el.value);

      // simples tentativa de manter o cursor numa posição natural
      const newLen = el.value.length;
      const diff = newLen - oldLen;
      el.selectionEnd = start + (diff > 0 ? diff : 0);
    });
    document.getElementById('nascimento').addEventListener('input', function(e) {
      let value = e.target.value.replace(/\D/g, '').slice(0, 8);
      if (value.length >= 5) value = value.replace(/(\d{2})(\d{2})(\d{0,4})/, '$1/$2/$3');
      else if (value.length >= 3) value = value.replace(/(\d{2})(\d{0,2})/, '$1/$2');
      e.target.value = value;
    });
    </script>
</body>

</html>

